/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.identity.impl.ldap;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.authorization.Permission;
import io.openbpm.bpm.engine.authorization.Permissions;
import io.openbpm.bpm.engine.authorization.Resource;
import io.openbpm.bpm.engine.authorization.Resources;
import io.openbpm.bpm.engine.identity.Group;
import io.openbpm.bpm.engine.identity.GroupQuery;
import io.openbpm.bpm.engine.identity.NativeUserQuery;
import io.openbpm.bpm.engine.identity.Tenant;
import io.openbpm.bpm.engine.identity.TenantQuery;
import io.openbpm.bpm.engine.identity.User;
import io.openbpm.bpm.engine.identity.UserQuery;
import io.openbpm.bpm.engine.impl.AbstractQuery;
import io.openbpm.bpm.engine.impl.Direction;
import io.openbpm.bpm.engine.impl.GroupQueryProperty;
import io.openbpm.bpm.engine.impl.QueryOrderingProperty;
import io.openbpm.bpm.engine.impl.UserQueryImpl;
import io.openbpm.bpm.engine.impl.UserQueryProperty;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.db.DbEntity;
import io.openbpm.bpm.engine.impl.identity.IdentityProviderException;
import io.openbpm.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.persistence.entity.GroupEntity;
import io.openbpm.bpm.engine.impl.persistence.entity.UserEntity;
import io.openbpm.bpm.identity.impl.ldap.LdapAuthenticationException;
import io.openbpm.bpm.identity.impl.ldap.LdapClient;
import io.openbpm.bpm.identity.impl.ldap.LdapConfiguration;
import io.openbpm.bpm.identity.impl.ldap.LdapGroupEntity;
import io.openbpm.bpm.identity.impl.ldap.LdapGroupQuery;
import io.openbpm.bpm.identity.impl.ldap.LdapSearchResults;
import io.openbpm.bpm.identity.impl.ldap.LdapTenantQuery;
import io.openbpm.bpm.identity.impl.ldap.LdapUserEntity;
import io.openbpm.bpm.identity.impl.ldap.LdapUserQueryImpl;
import io.openbpm.bpm.identity.impl.ldap.util.LdapPluginLogger;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortKey;

public class LdapIdentityProviderSession
implements ReadOnlyIdentityProvider {
    protected LdapConfiguration ldapConfiguration;
    protected LdapClient ldapClient;

    public LdapIdentityProviderSession(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
        this.ldapClient = new LdapClient(ldapConfiguration);
    }

    public void flush() {
    }

    public void close() {
        this.ldapClient.closeLdapCtx();
    }

    public User findUserById(String userId) {
        return (User)this.createUserQuery(Context.getCommandContext()).userId(userId).singleResult();
    }

    public UserQuery createUserQuery() {
        return new LdapUserQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired(), this.ldapConfiguration);
    }

    public UserQueryImpl createUserQuery(CommandContext commandContext) {
        return new LdapUserQueryImpl(this.ldapConfiguration);
    }

    public NativeUserQuery createNativeUserQuery() {
        throw new BadUserRequestException("Native user queries are not supported for LDAP identity service provider.");
    }

    public long findUserCountByQueryCriteria(LdapUserQueryImpl query) {
        this.ldapClient.ensureContextInitialized();
        return this.findUserByQueryCriteria(query).size();
    }

    public List<User> findUserByQueryCriteria(LdapUserQueryImpl query) {
        this.ldapClient.ensureContextInitialized();
        if (query.getEmailLike() != null) {
            query.userEmailLike(query.getEmailLike().replaceAll("%", "*"));
        }
        if (query.getFirstNameLike() != null) {
            query.userFirstNameLike(query.getFirstNameLike().replaceAll("%", "*"));
        }
        if (query.getLastNameLike() != null) {
            query.userLastNameLike(query.getLastNameLike().replaceAll("%", "*"));
        }
        if (query.getGroupId() != null) {
            return this.findUsersByGroupId(query);
        }
        String userBaseDn = this.composeDn(this.ldapConfiguration.getUserSearchBase(), this.ldapConfiguration.getBaseDn());
        return this.findUsersWithoutGroupId(query, userBaseDn, false);
    }

    protected boolean paginationContinues(int currentSize, int maxResults) {
        return this.nextPageDetected() && currentSize < maxResults;
    }

    protected List<User> findUsersByGroupId(LdapUserQueryImpl query) {
        String baseDn = this.getDnForGroup(query.getGroupId());
        String groupSearchFilter = "(& " + this.ldapConfiguration.getGroupSearchFilter() + ")";
        this.initializeControls((AbstractQuery<?, ?>)query);
        ArrayList<String> groupMembers = new ArrayList<String>();
        int resultCount = 0;
        do {
            try (LdapSearchResults searchResults = this.ldapClient.search(baseDn, groupSearchFilter);){
                while (searchResults.hasMoreElements()) {
                    String groupMemberAttribute = this.ldapConfiguration.getGroupMemberAttribute();
                    NamingEnumeration<String> allGroupMembers = LdapClient.getAllMembers(groupMemberAttribute, searchResults);
                    if (allGroupMembers == null) continue;
                    while (allGroupMembers.hasMoreElements()) {
                        if (resultCount >= query.getFirstResult()) {
                            groupMembers.add((String)allGroupMembers.nextElement());
                        }
                        ++resultCount;
                    }
                }
            }
        } while (this.paginationContinues(groupMembers.size(), query.getMaxResults()));
        ArrayList<User> userList = new ArrayList<User>();
        String userBaseDn = this.composeDn(this.ldapConfiguration.getUserSearchBase(), this.ldapConfiguration.getBaseDn());
        int memberCount = 0;
        for (String memberId : groupMembers) {
            if (userList.size() < query.getMaxResults() && memberCount >= query.getFirstResult()) {
                List<User> users;
                if (this.ldapConfiguration.isUsePosixGroups()) {
                    query.userId(memberId);
                }
                List<User> list = users = this.ldapConfiguration.isUsePosixGroups() ? this.findUsersWithoutGroupId(query, userBaseDn, true) : this.findUsersWithoutGroupId(query, memberId, true);
                if (!users.isEmpty()) {
                    userList.add(users.get(0));
                }
            }
            ++memberCount;
        }
        return userList;
    }

    public boolean checkPassword(String userId, String password) {
        if (password == null) {
            return false;
        }
        if (userId == null || userId.isEmpty()) {
            return false;
        }
        if (!this.ldapConfiguration.isAllowAnonymousLogin() && password.isEmpty()) {
            return false;
        }
        LdapUserEntity user = (LdapUserEntity)this.findUserById(userId);
        this.close();
        if (user == null) {
            return false;
        }
        LdapContext context = null;
        try {
            context = this.ldapClient.openContext(user.getDn(), password);
            boolean bl = true;
            this.ldapClient.closeLdapCtx(context);
            return bl;
        }
        catch (LdapAuthenticationException e) {
            block9: {
                try {
                    if (!this.ldapConfiguration.isPasswordCheckCatchAuthenticationException()) break block9;
                    boolean bl = false;
                    this.ldapClient.closeLdapCtx(context);
                    return bl;
                }
                catch (Throwable throwable) {
                    this.ldapClient.closeLdapCtx(context);
                    throw throwable;
                }
            }
            throw e;
        }
    }

    protected String getUserSearchFilter(LdapUserQueryImpl query) {
        StringWriter search = new StringWriter();
        search.write("(&");
        search.write(this.ldapConfiguration.getUserSearchFilter());
        if (query.getId() != null) {
            this.addFilter(this.ldapConfiguration.getUserIdAttribute(), this.escapeLDAPSearchFilter(query.getId()), search);
        }
        if (query.getIds() != null && query.getIds().length > 0) {
            search.write("(|");
            for (String userId : query.getIds()) {
                this.addFilter(this.ldapConfiguration.getUserIdAttribute(), this.escapeLDAPSearchFilter(userId), search);
            }
            search.write(")");
        }
        if (query.getEmail() != null) {
            this.addFilter(this.ldapConfiguration.getUserEmailAttribute(), query.getEmail(), search);
        }
        if (query.getEmailLike() != null) {
            this.addFilter(this.ldapConfiguration.getUserEmailAttribute(), query.getEmailLike(), search);
        }
        if (query.getFirstName() != null) {
            this.addFilter(this.ldapConfiguration.getUserFirstnameAttribute(), query.getFirstName(), search);
        }
        if (query.getFirstNameLike() != null) {
            this.addFilter(this.ldapConfiguration.getUserFirstnameAttribute(), query.getFirstNameLike(), search);
        }
        if (query.getLastName() != null) {
            this.addFilter(this.ldapConfiguration.getUserLastnameAttribute(), query.getLastName(), search);
        }
        if (query.getLastNameLike() != null) {
            this.addFilter(this.ldapConfiguration.getUserLastnameAttribute(), query.getLastNameLike(), search);
        }
        search.write(")");
        return search.toString();
    }

    protected boolean isAuthenticatedAndAuthorized(String userId) {
        return this.isAuthenticatedUser(userId) || this.isAuthorizedToRead((Resource)Resources.USER, userId);
    }

    public List<User> findUsersWithoutGroupId(LdapUserQueryImpl query, String userBaseDn, boolean ignorePagination) {
        this.initializeControls((AbstractQuery<?, ?>)query);
        return this.retrieveResults(userBaseDn, this.getUserSearchFilter(query), this::transformUser, this::isAuthenticatedAndAuthorized, query.getMaxResults(), query.getFirstResult(), ignorePagination);
    }

    public Group findGroupById(String groupId) {
        return (Group)this.createGroupQuery(Context.getCommandContext()).groupId(groupId).singleResult();
    }

    public GroupQuery createGroupQuery() {
        return new LdapGroupQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public GroupQuery createGroupQuery(CommandContext commandContext) {
        return new LdapGroupQuery();
    }

    public long findGroupCountByQueryCriteria(LdapGroupQuery ldapGroupQuery) {
        this.ldapClient.ensureContextInitialized();
        return this.findGroupByQueryCriteria(ldapGroupQuery).size();
    }

    protected boolean isAuthorizedToReadGroup(String groupId) {
        return this.isAuthorizedToRead((Resource)Resources.GROUP, groupId);
    }

    public List<Group> findGroupByQueryCriteria(LdapGroupQuery query) {
        if (query.getNameLike() != null) {
            query.groupNameLike(query.getNameLike().replaceAll("%", "*"));
        }
        this.ldapClient.ensureContextInitialized();
        String groupBaseDn = this.composeDn(this.ldapConfiguration.getGroupSearchBase(), this.ldapConfiguration.getBaseDn());
        this.initializeControls((AbstractQuery<?, ?>)query);
        return this.retrieveResults(groupBaseDn, this.getGroupSearchFilter(query), this::transformGroup, this::isAuthorizedToReadGroup, query.getMaxResults(), query.getFirstResult(), false);
    }

    protected String getGroupSearchFilter(LdapGroupQuery query) {
        StringWriter search = new StringWriter();
        search.write("(&");
        search.write(this.ldapConfiguration.getGroupSearchFilter());
        if (query.getId() != null) {
            this.addFilter(this.ldapConfiguration.getGroupIdAttribute(), query.getId(), search);
        }
        if (query.getIds() != null && query.getIds().length > 0) {
            search.write("(|");
            for (String id : query.getIds()) {
                this.addFilter(this.ldapConfiguration.getGroupIdAttribute(), id, search);
            }
            search.write(")");
        }
        if (query.getName() != null) {
            this.addFilter(this.ldapConfiguration.getGroupNameAttribute(), query.getName(), search);
        }
        if (query.getNameLike() != null) {
            this.addFilter(this.ldapConfiguration.getGroupNameAttribute(), query.getNameLike(), search);
        }
        if (query.getUserId() != null) {
            String userDn = null;
            userDn = this.ldapConfiguration.isUsePosixGroups() ? query.getUserId() : this.getDnForUser(query.getUserId());
            this.addFilter(this.ldapConfiguration.getGroupMemberAttribute(), this.escapeLDAPSearchFilter(userDn), search);
        }
        search.write(")");
        return search.toString();
    }

    protected <E extends DbEntity, T> List<T> retrieveResults(String baseDn, String filter, Function<SearchResult, E> transformEntity, Predicate<String> resultCountPredicate, int maxResults, int firstResult, boolean ignorePagination) {
        StringBuilder resultLogger = new StringBuilder();
        if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("LDAP query results: [");
        }
        ArrayList<DbEntity> entities = new ArrayList<DbEntity>();
        int resultCount = 0;
        do {
            try (LdapSearchResults searchResults = this.ldapClient.search(baseDn, filter);){
                while (searchResults.hasMoreElements() && (entities.size() < maxResults || ignorePagination)) {
                    SearchResult result = searchResults.nextElement();
                    DbEntity entity = (DbEntity)transformEntity.apply(result);
                    String id = entity.getId();
                    if (id == null) {
                        LdapPluginLogger.INSTANCE.invalidLdapEntityReturned(entity, result);
                        continue;
                    }
                    if (!resultCountPredicate.test(id)) continue;
                    if (resultCount >= firstResult || ignorePagination) {
                        if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
                            resultLogger.append(entity);
                            resultLogger.append(" based on ");
                            resultLogger.append(result);
                            resultLogger.append(", ");
                        }
                        entities.add(entity);
                    }
                    ++resultCount;
                }
            }
        } while (this.paginationContinues(entities.size(), maxResults));
        if (LdapPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("]");
            LdapPluginLogger.INSTANCE.queryResult(resultLogger.toString());
        }
        return entities;
    }

    protected String getDnForUser(String userId) {
        LdapUserEntity user = (LdapUserEntity)((Object)this.createUserQuery(Context.getCommandContext()).userId(userId).singleResult());
        if (user == null) {
            return "";
        }
        return user.getDn();
    }

    protected String getDnForGroup(String groupId) {
        LdapGroupEntity group = (LdapGroupEntity)((Object)this.createGroupQuery(Context.getCommandContext()).groupId(groupId).singleResult());
        if (group == null) {
            return "";
        }
        return group.getDn();
    }

    protected void addFilter(String attributeName, String attributeValue, StringWriter writer) {
        writer.write("(");
        writer.write(attributeName);
        writer.write("=");
        writer.write(attributeValue);
        writer.write(")");
    }

    protected UserEntity transformUser(SearchResult result) {
        Attributes attributes = result.getAttributes();
        LdapUserEntity user = new LdapUserEntity();
        user.setDn(result.getNameInNamespace());
        user.setId(LdapClient.getValue(this.ldapConfiguration.getUserIdAttribute(), attributes));
        user.setFirstName(LdapClient.getValue(this.ldapConfiguration.getUserFirstnameAttribute(), attributes));
        user.setLastName(LdapClient.getValue(this.ldapConfiguration.getUserLastnameAttribute(), attributes));
        user.setEmail(LdapClient.getValue(this.ldapConfiguration.getUserEmailAttribute(), attributes));
        return user;
    }

    protected GroupEntity transformGroup(SearchResult result) {
        Attributes attributes = result.getAttributes();
        LdapGroupEntity group = new LdapGroupEntity();
        group.setDn(result.getNameInNamespace());
        group.setId(LdapClient.getValue(this.ldapConfiguration.getGroupIdAttribute(), attributes));
        group.setName(LdapClient.getValue(this.ldapConfiguration.getGroupNameAttribute(), attributes));
        group.setType(LdapClient.getValue(this.ldapConfiguration.getGroupTypeAttribute(), attributes));
        return group;
    }

    protected List<Control> getSortingControls(AbstractQuery<?, ?> query) {
        ArrayList<Control> controls = new ArrayList<Control>();
        List orderBy = query.getOrderingProperties();
        if (orderBy != null) {
            for (QueryOrderingProperty orderingProperty : orderBy) {
                String propertyName = orderingProperty.getQueryProperty().getName();
                SortKey sortKey = this.getSortKey(query, propertyName, orderingProperty);
                if (sortKey == null) continue;
                LdapClient.addSortKey(sortKey, controls);
            }
        }
        return controls;
    }

    protected SortKey getSortKey(AbstractQuery<?, ?> query, String propertyName, QueryOrderingProperty orderingProperty) {
        if (query instanceof LdapUserQueryImpl) {
            if (UserQueryProperty.USER_ID.getName().equals(propertyName)) {
                return new SortKey(this.ldapConfiguration.getUserIdAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
            }
            if (UserQueryProperty.EMAIL.getName().equals(propertyName)) {
                return new SortKey(this.ldapConfiguration.getUserEmailAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
            }
            if (UserQueryProperty.FIRST_NAME.getName().equals(propertyName)) {
                return new SortKey(this.ldapConfiguration.getUserFirstnameAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
            }
            if (UserQueryProperty.LAST_NAME.getName().equals(propertyName)) {
                return new SortKey(this.ldapConfiguration.getUserLastnameAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
            }
        } else if (query instanceof LdapGroupQuery) {
            if (GroupQueryProperty.GROUP_ID.getName().equals(propertyName)) {
                return new SortKey(this.ldapConfiguration.getGroupIdAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
            }
            if (GroupQueryProperty.NAME.getName().equals(propertyName)) {
                return new SortKey(this.ldapConfiguration.getGroupNameAttribute(), Direction.ASCENDING.equals(orderingProperty.getDirection()), null);
            }
        }
        return null;
    }

    protected String composeDn(String ... parts) {
        StringWriter resultDn = new StringWriter();
        for (String s : parts) {
            String currentDn;
            String part = s;
            if (part == null || part.isEmpty()) continue;
            if (part.endsWith(",")) {
                part = part.substring(part.length() - 2, part.length() - 1);
            }
            if (part.startsWith(",")) {
                part = part.substring(1);
            }
            if (!(currentDn = resultDn.toString()).endsWith(",") && !currentDn.isEmpty()) {
                resultDn.write(",");
            }
            resultDn.write(part);
        }
        return resultDn.toString();
    }

    protected boolean isAuthenticatedUser(String userid) {
        if (userid == null) {
            return false;
        }
        return userid.equalsIgnoreCase(Context.getCommandContext().getAuthenticatedUserId());
    }

    protected boolean isAuthorizedToRead(Resource resource, String resourceId) {
        return !this.ldapConfiguration.isAuthorizationCheckEnabled() || Context.getCommandContext().getAuthorizationManager().isAuthorized((Permission)Permissions.READ, resource, resourceId);
    }

    protected final String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeControls(AbstractQuery<?, ?> query) {
        ArrayList<Control> listControls = new ArrayList<Control>();
        if (this.ldapConfiguration.isSortControlSupported()) {
            listControls.addAll(this.getSortingControls(query));
        }
        try {
            if (this.isPaginationSupported()) {
                LdapClient.addPaginationControl(listControls, null, this.getPageSize());
            }
        }
        catch (IdentityProviderException identityProviderException) {
        }
        finally {
            if (!listControls.isEmpty()) {
                this.ldapClient.setRequestControls(listControls);
            }
        }
    }

    protected boolean nextPageDetected() {
        if (!this.isPaginationSupported()) {
            return false;
        }
        Control[] controls = this.ldapClient.getResponseControls();
        if (controls == null) {
            return false;
        }
        ArrayList<Control> newControlList = new ArrayList<Control>();
        boolean newPageDetected = false;
        for (Control control : controls) {
            if (!(control instanceof PagedResultsResponseControl)) continue;
            PagedResultsResponseControl prrc = (PagedResultsResponseControl)control;
            byte[] cookie = prrc.getCookie();
            try {
                LdapClient.addPaginationControl(newControlList, cookie, this.getPageSize());
            }
            catch (IdentityProviderException e) {
                return false;
            }
            newPageDetected = cookie != null;
        }
        if (!newControlList.isEmpty()) {
            this.ldapClient.setRequestControls(newControlList);
        }
        return newPageDetected;
    }

    protected boolean isPaginationSupported() {
        return this.getPageSize() != null;
    }

    protected Integer getPageSize() {
        return this.ldapConfiguration.getPageSize();
    }

    public TenantQuery createTenantQuery() {
        return new LdapTenantQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public TenantQuery createTenantQuery(CommandContext commandContext) {
        return new LdapTenantQuery();
    }

    public Tenant findTenantById(String id) {
        return null;
    }
}

