/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.identity.impl.ldap;

import io.openbpm.bpm.engine.identity.User;
import io.openbpm.bpm.engine.identity.UserQuery;
import io.openbpm.bpm.engine.impl.Page;
import io.openbpm.bpm.engine.impl.UserQueryImpl;
import io.openbpm.bpm.engine.impl.interceptor.CommandContext;
import io.openbpm.bpm.engine.impl.interceptor.CommandExecutor;
import io.openbpm.bpm.identity.impl.ldap.LdapConfiguration;
import io.openbpm.bpm.identity.impl.ldap.LdapIdentityProviderSession;
import java.util.List;

public class LdapUserQueryImpl
extends UserQueryImpl {
    private static final long serialVersionUID = 1L;
    private final LdapConfiguration ldapConfiguration;

    public LdapUserQueryImpl(LdapConfiguration ldapConfiguration) {
        this.ldapConfiguration = ldapConfiguration;
    }

    public LdapUserQueryImpl(CommandExecutor commandExecutor, LdapConfiguration ldapConfiguration) {
        super(commandExecutor);
        this.ldapConfiguration = ldapConfiguration;
    }

    public long executeCount(CommandContext commandContext) {
        LdapIdentityProviderSession provider = this.getLdapIdentityProvider(commandContext);
        return provider.findUserCountByQueryCriteria(this);
    }

    public List<User> executeList(CommandContext commandContext, Page page) {
        LdapIdentityProviderSession provider = this.getLdapIdentityProvider(commandContext);
        return provider.findUserByQueryCriteria(this);
    }

    protected LdapIdentityProviderSession getLdapIdentityProvider(CommandContext commandContext) {
        return (LdapIdentityProviderSession)commandContext.getReadOnlyIdentityProvider();
    }

    public UserQuery desc() {
        if (this.ldapConfiguration != null && !this.ldapConfiguration.isSortControlSupported()) {
            throw new UnsupportedOperationException("The LDAP identity provider does not support descending search order.");
        }
        return this;
    }
}

