/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.feel.impl.juel;

import io.openbpm.bpm.dmn.feel.impl.FeelException;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelConvertException;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelMethodInvocationException;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelMissingFunctionException;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelMissingVariableException;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelSyntaxException;

public class FeelEngineLogger
extends FeelLogger {
    protected FeelSyntaxException syntaxException(String id, String feelExpression, String description) {
        return new FeelSyntaxException(this.syntaxExceptionMessage(id, feelExpression, description), feelExpression, description);
    }

    protected FeelSyntaxException syntaxException(String id, String feelExpression, String description, Throwable cause) {
        return new FeelSyntaxException(this.syntaxExceptionMessage(id, feelExpression, description), feelExpression, description, cause);
    }

    protected String syntaxExceptionMessage(String id, String feelExpression, String description) {
        if (description != null) {
            return this.exceptionMessage(id, "Syntax error in expression '{}': {}", new Object[]{feelExpression, description});
        }
        return this.exceptionMessage(id, "Syntax error in expression '{}'", new Object[]{feelExpression});
    }

    public FeelSyntaxException invalidNotExpression(String feelExpression) {
        String description = "Expression should have format 'not(...)'";
        return this.syntaxException("001", feelExpression, description);
    }

    public FeelSyntaxException invalidIntervalExpression(String feelExpression) {
        String description = "Expression should have format '[|(|] endpoint .. endpoint ]|)|['";
        return this.syntaxException("002", feelExpression, description);
    }

    public FeelSyntaxException invalidComparisonExpression(String feelExpression) {
        String description = "Expression should have format '<=|<|>=|> endpoint'";
        return this.syntaxException("003", feelExpression, description);
    }

    public FeelException variableMapperIsReadOnly() {
        return new FeelException(this.exceptionMessage("004", "The variable mapper is read only.", new Object[0]));
    }

    public FeelException unableToFindMethod(NoSuchMethodException cause, String name, Class<?> ... parameterTypes) {
        return new FeelException(this.exceptionMessage("005", "Unable to find method '{}' with parameter types '{}'", new Object[]{name, parameterTypes}), (Throwable)cause);
    }

    public FeelMissingFunctionException unknownFunction(String prefix, String localName) {
        Object function = localName;
        if (prefix != null && !prefix.isEmpty()) {
            function = prefix + ":" + localName;
        }
        return new FeelMissingFunctionException(this.exceptionMessage("006", "Unable to resolve function '{}'", new Object[]{function}), (String)function);
    }

    public FeelMissingFunctionException unknownFunction(String feelExpression, FeelMissingFunctionException cause) {
        String function = cause.getFunction();
        return new FeelMissingFunctionException(this.exceptionMessage("007", "Unable to resolve function '{}' in expression '{}'", new Object[]{function, feelExpression}), function);
    }

    public FeelMissingVariableException unknownVariable(String variable) {
        return new FeelMissingVariableException(this.exceptionMessage("008", "Unable to resolve variable '{}'", new Object[]{variable}), variable);
    }

    public FeelMissingVariableException unknownVariable(String feelExpression, FeelMissingVariableException cause) {
        String variable = cause.getVariable();
        return new FeelMissingVariableException(this.exceptionMessage("009", "Unable to resolve variable '{}' in expression '{}'", new Object[]{variable, feelExpression}), variable);
    }

    public FeelSyntaxException invalidExpression(String feelExpression, Throwable cause) {
        return this.syntaxException("010", feelExpression, null, cause);
    }

    public FeelException unableToInitializeFeelEngine(Throwable cause) {
        return new FeelException(this.exceptionMessage("011", "Unable to initialize FEEL engine", new Object[0]), cause);
    }

    public FeelException unableToEvaluateExpression(String simpleUnaryTests, Throwable cause) {
        return new FeelException(this.exceptionMessage("012", "Unable to evaluate expression '{}'", new Object[]{simpleUnaryTests}), cause);
    }

    public FeelConvertException unableToConvertValue(Object value, Class<?> type) {
        return new FeelConvertException(this.exceptionMessage("013", "Unable to convert value '{}' of type '{}' to type '{}'", new Object[]{value, value.getClass(), type}), value, type);
    }

    public FeelConvertException unableToConvertValue(Object value, Class<?> type, Throwable cause) {
        return new FeelConvertException(this.exceptionMessage("014", "Unable to convert value '{}' of type '{}' to type '{}'", new Object[]{value, value.getClass(), type}), value, type, cause);
    }

    public FeelConvertException unableToConvertValue(String feelExpression, FeelConvertException cause) {
        Object value = cause.getValue();
        Class<?> type = cause.getType();
        return new FeelConvertException(this.exceptionMessage("015", "Unable to convert value '{}' of type '{}' to type '{}' in expression '{}'", new Object[]{value, value.getClass(), type, feelExpression}), cause);
    }

    public UnsupportedOperationException simpleExpressionNotSupported() {
        return new UnsupportedOperationException(this.exceptionMessage("016", "Simple Expression not supported by FEEL engine", new Object[0]));
    }

    public FeelException unableToEvaluateExpressionAsNotInputIsSet(String simpleUnaryTests, FeelMissingVariableException e) {
        return new FeelException(this.exceptionMessage("017", "Unable to evaluate expression '{}' as no input is set. Maybe the inputExpression is missing or empty.", new Object[]{simpleUnaryTests}), (Throwable)((Object)e));
    }

    public FeelMethodInvocationException invalidDateAndTimeFormat(String dateTimeString, Throwable cause) {
        return new FeelMethodInvocationException(this.exceptionMessage("018", "Invalid date and time format in '{}'", new Object[]{dateTimeString}), cause, "date and time", dateTimeString);
    }

    public FeelMethodInvocationException unableToInvokeMethod(String simpleUnaryTests, FeelMethodInvocationException cause) {
        String method = cause.getMethod();
        String[] parameters = cause.getParameters();
        return new FeelMethodInvocationException(this.exceptionMessage("019", "Unable to invoke method '{}' with parameters '{}' in expression '{}'", new Object[]{method, parameters, simpleUnaryTests}), cause.getCause(), method, parameters);
    }

    public FeelSyntaxException invalidListExpression(String feelExpression) {
        String description = "List expression can not have empty elements";
        return this.syntaxException("020", feelExpression, description);
    }
}

