/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.feel.impl.juel.el;

import io.openbpm.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelLogger;
import io.openbpm.bpm.impl.juel.TypeConverterImpl;
import jakarta.el.ELException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FeelTypeConverter
extends TypeConverterImpl {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;

    protected Boolean coerceToBoolean(Object value) {
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            return booleanValue;
        }
        throw LOG.unableToConvertValue(value, Boolean.class);
    }

    protected BigDecimal coerceToBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            return bigDecimalValue;
        }
        if (value instanceof BigInteger) {
            BigInteger bigIntegerValue = (BigInteger)value;
            return new BigDecimal(bigIntegerValue);
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return BigDecimal.valueOf(numberValue.doubleValue());
        }
        throw LOG.unableToConvertValue(value, BigDecimal.class);
    }

    protected BigInteger coerceToBigInteger(Object value) {
        if (value instanceof BigInteger) {
            BigInteger bigIntegerValue = (BigInteger)value;
            return bigIntegerValue;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)value;
            return bigDecimalValue.toBigInteger();
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return BigInteger.valueOf(numberValue.longValue());
        }
        throw LOG.unableToConvertValue(value, BigInteger.class);
    }

    protected Double coerceToDouble(Object value) {
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return doubleValue;
        }
        if (value instanceof Number) {
            Number numberValue = (Number)value;
            return numberValue.doubleValue();
        }
        throw LOG.unableToConvertValue(value, Double.class);
    }

    protected Long coerceToLong(Object value) {
        Number numberValue;
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return longValue;
        }
        if (value instanceof Number && this.isLong(numberValue = (Number)value)) {
            return numberValue.longValue();
        }
        throw LOG.unableToConvertValue(value, Long.class);
    }

    protected String coerceToString(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            return stringValue;
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return enumValue.name();
        }
        throw LOG.unableToConvertValue(value, String.class);
    }

    public <T> T convert(Object value, Class<T> type) throws ELException {
        try {
            return (T)super.convert(value, type);
        }
        catch (ELException e) {
            throw LOG.unableToConvertValue(value, type, e);
        }
    }

    protected boolean isLong(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((long)doubleValue);
    }
}

