/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.feel.impl.juel.transform;

import io.openbpm.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.FeelLogger;
import io.openbpm.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import io.openbpm.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListTransformer
implements FeelToJuelTransformer {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    public static final String COMMA_SEPARATOR_REGEX = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";

    @Override
    public boolean canTransform(String feelExpression) {
        return this.splitExpression(feelExpression).size() > 1;
    }

    @Override
    public String transform(FeelToJuelTransform transform, String feelExpression, String inputName) {
        List<String> juelExpressions = this.transformExpressions(transform, feelExpression, inputName);
        return this.joinExpressions(juelExpressions);
    }

    protected List<String> collectExpressions(String feelExpression) {
        return this.splitExpression(feelExpression);
    }

    private List<String> splitExpression(String feelExpression) {
        return Arrays.asList(feelExpression.split(COMMA_SEPARATOR_REGEX, -1));
    }

    protected List<String> transformExpressions(FeelToJuelTransform transform, String feelExpression, String inputName) {
        List<String> expressions = this.collectExpressions(feelExpression);
        ArrayList<String> juelExpressions = new ArrayList<String>();
        for (String expression : expressions) {
            if (!expression.trim().isEmpty()) {
                String juelExpression = transform.transformSimplePositiveUnaryTest(expression, inputName);
                juelExpressions.add(juelExpression);
                continue;
            }
            throw LOG.invalidListExpression(feelExpression);
        }
        return juelExpressions;
    }

    protected String joinExpressions(List<String> juelExpressions) {
        StringBuilder builder = new StringBuilder();
        builder.append("(").append(juelExpressions.get(0)).append(")");
        for (int i = 1; i < juelExpressions.size(); ++i) {
            builder.append(" || (").append(juelExpressions.get(i)).append(")");
        }
        return builder.toString();
    }
}

