/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.impl;

import io.openbpm.bpm.dmn.engine.DmnDecision;
import io.openbpm.bpm.dmn.engine.DmnDecisionLogic;
import io.openbpm.bpm.dmn.engine.DmnDecisionResult;
import io.openbpm.bpm.dmn.engine.DmnDecisionResultEntries;
import io.openbpm.bpm.dmn.engine.DmnDecisionRuleResult;
import io.openbpm.bpm.dmn.engine.DmnDecisionTableResult;
import io.openbpm.bpm.dmn.engine.DmnEngineException;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionResultException;
import io.openbpm.bpm.dmn.engine.impl.DmnEvaluationException;
import io.openbpm.bpm.dmn.engine.impl.DmnLogger;
import io.openbpm.bpm.dmn.engine.impl.transform.DmnTransformException;

public class DmnEngineLogger
extends DmnLogger {
    public DmnTransformException unableToFindDecisionWithKey(String decisionKey) {
        return new DmnTransformException(this.exceptionMessage("001", "Unable to find decision with id '{}' in model.", new Object[]{decisionKey}));
    }

    public DmnEvaluationException unableToEvaluateExpression(String expression, String expressionLanguage, Throwable cause) {
        return new DmnEvaluationException(this.exceptionMessage("002", "Unable to evaluate expression for language '{}': '{}'", new Object[]{expressionLanguage, expression}), cause);
    }

    public DmnEvaluationException noScriptEngineFoundForLanguage(String expressionLanguage) {
        return new DmnEvaluationException(this.exceptionMessage("003", "Unable to find script engine for expression language '{}'.", new Object[]{expressionLanguage}));
    }

    public DmnEngineException decisionTypeNotSupported(DmnDecision decision) {
        return new DmnEngineException(this.exceptionMessage("004", "Decision type '{}' not supported by DMN engine.", new Object[]{decision.getClass()}));
    }

    public DmnEngineException invalidValueForTypeDefinition(String typeName, Object value) {
        return new DmnEngineException(this.exceptionMessage("005", "Invalid value '{}' for clause with type '{}'.", new Object[]{value, typeName}));
    }

    public void unsupportedTypeDefinitionForClause(String typeName) {
        this.logWarn("006", "Unsupported type '{}' for clause. Values of this clause will not transform into another type.", new Object[]{typeName});
    }

    public DmnDecisionResultException decisionOutputHasMoreThanOneValue(DmnDecisionRuleResult ruleResult) {
        return new DmnDecisionResultException(this.exceptionMessage("007", "Unable to get single decision rule result entry as it has more than one entry '{}'", new Object[]{ruleResult}));
    }

    public DmnDecisionResultException decisionResultHasMoreThanOneOutput(DmnDecisionTableResult decisionResult) {
        return new DmnDecisionResultException(this.exceptionMessage("008", "Unable to get single decision rule result as it has more than one rule result '{}'", new Object[]{decisionResult}));
    }

    public DmnTransformException unableToFindAnyDecisionTable() {
        return new DmnTransformException(this.exceptionMessage("009", "Unable to find any decision table in model.", new Object[0]));
    }

    public DmnDecisionResultException decisionOutputHasMoreThanOneValue(DmnDecisionResultEntries result) {
        return new DmnDecisionResultException(this.exceptionMessage("010", "Unable to get single decision result entry as it has more than one entry '{}'", new Object[]{result}));
    }

    public DmnDecisionResultException decisionResultHasMoreThanOneOutput(DmnDecisionResult decisionResult) {
        return new DmnDecisionResultException(this.exceptionMessage("011", "Unable to get single decision result as it has more than one result '{}'", new Object[]{decisionResult}));
    }

    public DmnEngineException decisionLogicTypeNotSupported(DmnDecisionLogic decisionLogic) {
        return new DmnEngineException(this.exceptionMessage("012", "Decision logic type '{}' not supported by DMN engine.", new Object[]{decisionLogic.getClass()}));
    }

    public DmnEngineException decisionIsNotADecisionTable(DmnDecision decision) {
        return new DmnEngineException(this.exceptionMessage("013", "The decision '{}' is not implemented as decision table.", new Object[]{decision}));
    }
}

