/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.impl.evaluation;

import io.openbpm.bpm.dmn.engine.DmnDecision;
import io.openbpm.bpm.dmn.engine.DmnDecisionResult;
import io.openbpm.bpm.dmn.engine.delegate.DmnDecisionLiteralExpressionEvaluationEvent;
import io.openbpm.bpm.dmn.engine.delegate.DmnDecisionLogicEvaluationEvent;
import io.openbpm.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionLiteralExpressionImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionResultEntriesImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnDecisionResultImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnExpressionImpl;
import io.openbpm.bpm.dmn.engine.impl.DmnVariableImpl;
import io.openbpm.bpm.dmn.engine.impl.delegate.DmnDecisionLiteralExpressionEvaluationEventImpl;
import io.openbpm.bpm.dmn.engine.impl.evaluation.DmnDecisionLogicEvaluationHandler;
import io.openbpm.bpm.dmn.engine.impl.evaluation.ExpressionEvaluationHandler;
import io.openbpm.bpm.engine.variable.context.VariableContext;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import java.util.Collections;

public class DecisionLiteralExpressionEvaluationHandler
implements DmnDecisionLogicEvaluationHandler {
    protected final ExpressionEvaluationHandler expressionEvaluationHandler;
    protected final String literalExpressionLanguage;

    public DecisionLiteralExpressionEvaluationHandler(DefaultDmnEngineConfiguration configuration) {
        this.expressionEvaluationHandler = new ExpressionEvaluationHandler(configuration);
        this.literalExpressionLanguage = configuration.getDefaultLiteralExpressionLanguage();
    }

    @Override
    public DmnDecisionLogicEvaluationEvent evaluate(DmnDecision decision, VariableContext variableContext) {
        DmnDecisionLiteralExpressionEvaluationEventImpl evaluationResult = new DmnDecisionLiteralExpressionEvaluationEventImpl();
        evaluationResult.setDecision(decision);
        evaluationResult.setExecutedDecisionElements(1L);
        DmnDecisionLiteralExpressionImpl dmnDecisionLiteralExpression = (DmnDecisionLiteralExpressionImpl)decision.getDecisionLogic();
        DmnVariableImpl variable = dmnDecisionLiteralExpression.getVariable();
        DmnExpressionImpl expression = dmnDecisionLiteralExpression.getExpression();
        Object evaluateExpression = this.evaluateLiteralExpression(expression, variableContext);
        TypedValue typedValue = variable.getTypeDefinition().transform(evaluateExpression);
        evaluationResult.setOutputValue(typedValue);
        evaluationResult.setOutputName(variable.getName());
        return evaluationResult;
    }

    protected Object evaluateLiteralExpression(DmnExpressionImpl expression, VariableContext variableContext) {
        String expressionLanguage = expression.getExpressionLanguage();
        if (expressionLanguage == null) {
            expressionLanguage = this.literalExpressionLanguage;
        }
        return this.expressionEvaluationHandler.evaluateExpression(expressionLanguage, expression, variableContext);
    }

    @Override
    public DmnDecisionResult generateDecisionResult(DmnDecisionLogicEvaluationEvent event) {
        DmnDecisionLiteralExpressionEvaluationEvent evaluationEvent = (DmnDecisionLiteralExpressionEvaluationEvent)event;
        DmnDecisionResultEntriesImpl result = new DmnDecisionResultEntriesImpl();
        result.putValue(evaluationEvent.getOutputName(), evaluationEvent.getOutputValue());
        return new DmnDecisionResultImpl(Collections.singletonList(result));
    }
}

