/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.impl.type;

import io.openbpm.bpm.dmn.engine.impl.DmnEngineLogger;
import io.openbpm.bpm.dmn.engine.impl.DmnLogger;
import io.openbpm.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformer;
import io.openbpm.bpm.dmn.engine.impl.spi.type.DmnTypeDefinition;
import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import io.openbpm.commons.utils.EnsureUtil;

public class DmnTypeDefinitionImpl
implements DmnTypeDefinition {
    protected static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected String typeName;
    protected DmnDataTypeTransformer transformer;

    public DmnTypeDefinitionImpl(String typeName, DmnDataTypeTransformer transformer) {
        this.typeName = typeName;
        this.transformer = transformer;
    }

    @Override
    public TypedValue transform(Object value) {
        if (value == null) {
            return Variables.untypedNullValue();
        }
        return this.transformNotNullValue(value);
    }

    protected TypedValue transformNotNullValue(Object value) {
        EnsureUtil.ensureNotNull((String)"transformer", (Object)this.transformer);
        try {
            return this.transformer.transform(value);
        }
        catch (IllegalArgumentException e) {
            throw LOG.invalidValueForTypeDefinition(this.typeName, value);
        }
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTransformer(DmnDataTypeTransformer transformer) {
        this.transformer = transformer;
    }

    public String toString() {
        return "DmnTypeDefinitionImpl{typeName='" + this.typeName + "'}";
    }
}

