/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.test;

import io.openbpm.bpm.dmn.engine.DmnDecision;
import io.openbpm.bpm.dmn.engine.DmnEngineConfiguration;
import io.openbpm.bpm.dmn.engine.test.DecisionResource;
import io.openbpm.bpm.dmn.engine.test.DmnEngineExtension;
import io.openbpm.commons.utils.IoUtil;
import java.io.InputStream;
import java.util.List;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class DmnEngineTestExtension
extends DmnEngineExtension
implements BeforeEachCallback {
    private static final String DMN_SUFFIX = "dmn";
    protected DmnDecision decision;

    public DmnEngineTestExtension(DmnEngineConfiguration dmnEngineConfiguration) {
        super(dmnEngineConfiguration);
    }

    public DmnDecision getDecision() {
        return this.decision;
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        super.beforeEach(context);
        this.decision = this.loadDecision(context);
    }

    protected DmnDecision loadDecision(ExtensionContext context) {
        DecisionResource decisionResource = context.getRequiredTestMethod().getAnnotation(DecisionResource.class);
        if (decisionResource == null) {
            return null;
        }
        String resourcePath = decisionResource.resource();
        resourcePath = this.expandResourcePath(context, resourcePath);
        InputStream inputStream = IoUtil.fileAsStream((String)resourcePath);
        String decisionKey = decisionResource.decisionKey();
        if (decisionKey == null || decisionKey.isEmpty()) {
            List<DmnDecision> decisions = this.dmnEngine.parseDecisions(inputStream);
            return decisions.isEmpty() ? null : decisions.get(0);
        }
        return this.dmnEngine.parseDecision(decisionKey, inputStream);
    }

    protected String expandResourcePath(ExtensionContext context, String resourcePath) {
        if (resourcePath.contains("/")) {
            return resourcePath;
        }
        Class testClass = (Class)context.getTestClass().orElseThrow();
        if (resourcePath.isEmpty()) {
            return testClass.getName().replace(".", "/") + "." + context.getRequiredTestMethod().getName() + ".dmn";
        }
        return testClass.getPackage().getName().replace(".", "/") + "/" + resourcePath;
    }
}

