/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.dmn.engine.test;

import io.openbpm.bpm.dmn.engine.DmnDecision;
import io.openbpm.bpm.dmn.engine.DmnEngineConfiguration;
import io.openbpm.bpm.dmn.engine.test.DecisionResource;
import io.openbpm.bpm.dmn.engine.test.DmnEngineRule;
import io.openbpm.commons.utils.IoUtil;
import java.io.InputStream;
import java.util.List;
import org.junit.runner.Description;

public class DmnEngineTestRule
extends DmnEngineRule {
    public static final String DMN_SUFFIX = "dmn";
    protected DmnDecision decision;

    public DmnEngineTestRule() {
    }

    public DmnEngineTestRule(DmnEngineConfiguration dmnEngineConfiguration) {
        super(dmnEngineConfiguration);
    }

    public DmnDecision getDecision() {
        return this.decision;
    }

    @Override
    protected void starting(Description description) {
        super.starting(description);
        this.decision = this.loadDecision(description);
    }

    protected DmnDecision loadDecision(Description description) {
        DecisionResource decisionResource = (DecisionResource)description.getAnnotation(DecisionResource.class);
        if (decisionResource != null) {
            String resourcePath = decisionResource.resource();
            resourcePath = this.expandResourcePath(description, resourcePath);
            InputStream inputStream = IoUtil.fileAsStream((String)resourcePath);
            String decisionKey = decisionResource.decisionKey();
            if (decisionKey == null || decisionKey.isEmpty()) {
                List<DmnDecision> decisions = this.dmnEngine.parseDecisions(inputStream);
                if (!decisions.isEmpty()) {
                    return decisions.get(0);
                }
                return null;
            }
            return this.dmnEngine.parseDecision(decisionKey, inputStream);
        }
        return null;
    }

    protected String expandResourcePath(Description description, String resourcePath) {
        if (resourcePath.contains("/")) {
            return resourcePath;
        }
        Class testClass = description.getTestClass();
        if (resourcePath.isEmpty()) {
            return testClass.getName().replace(".", "/") + "." + description.getMethodName() + ".dmn";
        }
        return testClass.getPackage().getName().replace(".", "/") + "/" + resourcePath;
    }
}

