/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.xml.impl.parser;

import io.openbpm.bpm.model.xml.ModelInstance;
import io.openbpm.bpm.model.xml.ModelValidationException;
import io.openbpm.bpm.model.xml.impl.util.DomUtil;
import io.openbpm.bpm.model.xml.impl.util.ReflectUtil;
import io.openbpm.bpm.model.xml.instance.DomDocument;
import io.openbpm.bpm.model.xml.instance.DomElement;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public abstract class AbstractModelParser {
    protected static final String JAXP_ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
    protected static final String JAXP_ACCESS_EXTERNAL_SCHEMA_SYSTEM_PROPERTY = "javax.xml.accessExternalSchema";
    protected static final String JAXP_ACCESS_EXTERNAL_SCHEMA_ALL = "all";
    private final DocumentBuilderFactory documentBuilderFactory;
    protected SchemaFactory schemaFactory;
    protected Map<String, Schema> schemas = new HashMap<String, Schema>();

    protected AbstractModelParser() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        this.configureFactory(dbf);
        this.documentBuilderFactory = dbf;
    }

    protected void configureFactory(DocumentBuilderFactory dbf) {
        dbf.setValidating(true);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(false);
        dbf.setNamespaceAware(true);
        this.protectAgainstXxeAttacks(dbf);
        this.enableSecureProcessing(dbf);
    }

    private void protectAgainstXxeAttacks(DocumentBuilderFactory dbf) {
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
    }

    private void enableSecureProcessing(DocumentBuilderFactory dbf) {
        try {
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setAttribute(JAXP_ACCESS_EXTERNAL_SCHEMA, this.resolveAccessExternalSchemaProperty());
        }
        catch (IllegalArgumentException | ParserConfigurationException exception) {
            // empty catch block
        }
    }

    protected String resolveAccessExternalSchemaProperty() {
        String systemProperty = System.getProperty(JAXP_ACCESS_EXTERNAL_SCHEMA_SYSTEM_PROPERTY);
        if (systemProperty != null) {
            return systemProperty;
        }
        return JAXP_ACCESS_EXTERNAL_SCHEMA_ALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelInstance parseModelFromStream(InputStream inputStream) {
        DomDocument document = null;
        DocumentBuilderFactory documentBuilderFactory = this.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            document = DomUtil.parseInputStream(this.documentBuilderFactory, inputStream);
        }
        this.validateModel(document);
        return this.createModelInstance(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelInstance getEmptyModel() {
        DomDocument document = null;
        DocumentBuilderFactory documentBuilderFactory = this.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            document = DomUtil.getEmptyDocument(this.documentBuilderFactory);
        }
        return this.createModelInstance(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateModel(DomDocument document) {
        Schema schema = this.getSchema(document);
        if (schema == null) {
            return;
        }
        Validator validator = schema.newValidator();
        try {
            DomDocument domDocument = document;
            synchronized (domDocument) {
                validator.validate(document.getDomSource());
            }
        }
        catch (IOException e) {
            throw new ModelValidationException("Error during DOM document validation", e);
        }
        catch (SAXException e) {
            throw new ModelValidationException("DOM document is not valid", e);
        }
    }

    protected Schema getSchema(DomDocument document) {
        DomElement rootElement = document.getRootElement();
        String namespaceURI = rootElement.getNamespaceURI();
        return this.schemas.get(namespaceURI);
    }

    protected void addSchema(String namespaceURI, Schema schema) {
        this.schemas.put(namespaceURI, schema);
    }

    protected Schema createSchema(String location, ClassLoader classLoader) {
        URL cmmnSchema = ReflectUtil.getResource(location, classLoader);
        try {
            return this.schemaFactory.newSchema(cmmnSchema);
        }
        catch (SAXException e) {
            throw new ModelValidationException("Unable to parse schema:" + String.valueOf(cmmnSchema));
        }
    }

    protected abstract ModelInstance createModelInstance(DomDocument var1);
}

