/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.xml.impl.type.reference;

import io.openbpm.bpm.model.xml.Model;
import io.openbpm.bpm.model.xml.ModelException;
import io.openbpm.bpm.model.xml.impl.ModelBuildOperation;
import io.openbpm.bpm.model.xml.impl.type.ModelElementTypeImpl;
import io.openbpm.bpm.model.xml.impl.type.attribute.AttributeImpl;
import io.openbpm.bpm.model.xml.impl.type.reference.AttributeReferenceImpl;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;
import io.openbpm.bpm.model.xml.type.reference.AttributeReference;
import io.openbpm.bpm.model.xml.type.reference.AttributeReferenceBuilder;

public class AttributeReferenceBuilderImpl<T extends ModelElementInstance>
implements AttributeReferenceBuilder<T>,
ModelBuildOperation {
    private final AttributeImpl<String> referenceSourceAttribute;
    protected AttributeReferenceImpl<T> attributeReferenceImpl;
    private final Class<T> referenceTargetElement;

    public AttributeReferenceBuilderImpl(AttributeImpl<String> referenceSourceAttribute, Class<T> referenceTargetElement) {
        this.referenceSourceAttribute = referenceSourceAttribute;
        this.referenceTargetElement = referenceTargetElement;
        this.attributeReferenceImpl = new AttributeReferenceImpl(referenceSourceAttribute);
    }

    @Override
    public AttributeReference<T> build() {
        this.referenceSourceAttribute.registerOutgoingReference(this.attributeReferenceImpl);
        return this.attributeReferenceImpl;
    }

    @Override
    public void performModelBuild(Model model) {
        ModelElementTypeImpl referenceTargetType = (ModelElementTypeImpl)model.getType(this.referenceTargetElement);
        this.attributeReferenceImpl.setReferenceTargetElementType(referenceTargetType);
        AttributeImpl idAttribute = (AttributeImpl)referenceTargetType.getAttribute("id");
        if (idAttribute == null) {
            throw new ModelException("Element type " + referenceTargetType.getTypeNamespace() + ":" + referenceTargetType.getTypeName() + " has no id attribute");
        }
        idAttribute.registerIncoming(this.attributeReferenceImpl);
        this.attributeReferenceImpl.setReferenceTargetAttribute(idAttribute);
    }
}

