/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.xml.impl.type.reference;

import io.openbpm.bpm.model.xml.ModelInstance;
import io.openbpm.bpm.model.xml.ModelReferenceException;
import io.openbpm.bpm.model.xml.impl.type.ModelElementTypeImpl;
import io.openbpm.bpm.model.xml.impl.type.attribute.AttributeImpl;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;
import io.openbpm.bpm.model.xml.type.ModelElementType;
import io.openbpm.bpm.model.xml.type.attribute.Attribute;
import io.openbpm.bpm.model.xml.type.reference.Reference;
import java.util.Collection;
import java.util.Collections;

public abstract class ReferenceImpl<T extends ModelElementInstance>
implements Reference<T> {
    protected AttributeImpl<String> referenceTargetAttribute;
    private ModelElementTypeImpl referenceTargetElementType;

    protected abstract void setReferenceIdentifier(ModelElementInstance var1, String var2);

    @Override
    public T getReferenceTargetElement(ModelElementInstance referenceSourceElement) {
        String identifier = this.getReferenceIdentifier(referenceSourceElement);
        Object referenceTargetElement = referenceSourceElement.getModelInstance().getModelElementById(identifier);
        if (referenceTargetElement != null) {
            try {
                return referenceTargetElement;
            }
            catch (ClassCastException e) {
                throw new ModelReferenceException("Element " + String.valueOf(referenceSourceElement) + " references element " + String.valueOf(referenceTargetElement) + " of wrong type. Expecting " + String.valueOf(this.referenceTargetAttribute.getOwningElementType()) + " got " + String.valueOf(referenceTargetElement.getElementType()));
            }
        }
        return null;
    }

    @Override
    public void setReferenceTargetElement(ModelElementInstance referenceSourceElement, T referenceTargetElement) {
        String referenceTargetIdentifier;
        ModelInstance modelInstance = referenceSourceElement.getModelInstance();
        Object existingElement = modelInstance.getModelElementById(referenceTargetIdentifier = this.referenceTargetAttribute.getValue((ModelElementInstance)referenceTargetElement));
        if (existingElement == null || !existingElement.equals(referenceTargetElement)) {
            throw new ModelReferenceException("Cannot create reference to model element " + String.valueOf(referenceTargetElement) + ": element is not part of model. Please connect element to the model first.");
        }
        this.setReferenceIdentifier(referenceSourceElement, referenceTargetIdentifier);
    }

    public void setReferenceTargetAttribute(AttributeImpl<String> referenceTargetAttribute) {
        this.referenceTargetAttribute = referenceTargetAttribute;
    }

    @Override
    public Attribute<String> getReferenceTargetAttribute() {
        return this.referenceTargetAttribute;
    }

    public void setReferenceTargetElementType(ModelElementTypeImpl referenceTargetElementType) {
        this.referenceTargetElementType = referenceTargetElementType;
    }

    @Override
    public Collection<ModelElementInstance> findReferenceSourceElements(ModelElementInstance referenceTargetElement) {
        if (this.referenceTargetElementType.isBaseTypeOf(referenceTargetElement.getElementType())) {
            ModelElementType owningElementType = this.getReferenceSourceElementType();
            return referenceTargetElement.getModelInstance().getModelElementsByType(owningElementType);
        }
        return Collections.emptyList();
    }

    protected abstract void updateReference(ModelElementInstance var1, String var2, String var3);

    public void referencedElementUpdated(ModelElementInstance referenceTargetElement, String oldIdentifier, String newIdentifier) {
        for (ModelElementInstance referenceSourceElement : this.findReferenceSourceElements(referenceTargetElement)) {
            this.updateReference(referenceSourceElement, oldIdentifier, newIdentifier);
        }
    }

    protected abstract void removeReference(ModelElementInstance var1, ModelElementInstance var2);

    public void referencedElementRemoved(ModelElementInstance referenceTargetElement, Object referenceIdentifier) {
        for (ModelElementInstance referenceSourceElement : this.findReferenceSourceElements(referenceTargetElement)) {
            if (!referenceIdentifier.equals(this.getReferenceIdentifier(referenceSourceElement))) continue;
            this.removeReference(referenceSourceElement, referenceTargetElement);
        }
    }
}

