/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.xml.impl.util;

import io.openbpm.bpm.model.xml.Model;
import io.openbpm.bpm.model.xml.ModelException;
import io.openbpm.bpm.model.xml.impl.ModelInstanceImpl;
import io.openbpm.bpm.model.xml.impl.type.ModelElementTypeImpl;
import io.openbpm.bpm.model.xml.impl.type.attribute.StringAttribute;
import io.openbpm.bpm.model.xml.impl.util.ModelTypeException;
import io.openbpm.bpm.model.xml.impl.util.QName;
import io.openbpm.bpm.model.xml.instance.DomElement;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;
import io.openbpm.bpm.model.xml.type.ModelElementType;
import io.openbpm.bpm.model.xml.type.attribute.Attribute;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public final class ModelUtil {
    private static final String ID_ATTRIBUTE_NAME = "id";

    private ModelUtil() {
    }

    public static ModelElementInstance getModelElement(DomElement domElement, ModelInstanceImpl modelInstance) {
        ModelElementInstance modelElement = domElement.getModelElementInstance();
        if (modelElement == null) {
            ModelElementTypeImpl modelType = ModelUtil.getModelElement(domElement, modelInstance, domElement.getNamespaceURI());
            modelElement = modelType.newInstance(modelInstance, domElement);
            domElement.setModelElementInstance(modelElement);
        }
        return modelElement;
    }

    public static ModelElementInstance getModelElement(DomElement domElement, ModelInstanceImpl modelInstance, ModelElementTypeImpl modelType) {
        ModelElementInstance modelElement = domElement.getModelElementInstance();
        if (modelElement == null) {
            modelElement = modelType.newInstance(modelInstance, domElement);
            domElement.setModelElementInstance(modelElement);
        }
        return modelElement;
    }

    protected static ModelElementTypeImpl getModelElement(DomElement domElement, ModelInstanceImpl modelInstance, String namespaceUri) {
        String localName = domElement.getLocalName();
        ModelElementTypeImpl modelType = (ModelElementTypeImpl)modelInstance.getModel().getTypeForName(namespaceUri, localName);
        if (modelType == null) {
            Model model = modelInstance.getModel();
            String actualNamespaceUri = model.getActualNamespace(namespaceUri);
            modelType = actualNamespaceUri != null ? ModelUtil.getModelElement(domElement, modelInstance, actualNamespaceUri) : (ModelElementTypeImpl)modelInstance.registerGenericType(namespaceUri, localName);
        }
        return modelType;
    }

    public static QName getQName(String namespaceUri, String localName) {
        return new QName(namespaceUri, localName);
    }

    public static void ensureInstanceOf(Object instance, Class<?> type) {
        if (!type.isAssignableFrom(instance.getClass())) {
            throw new ModelException("Object is not instance of type " + type.getName());
        }
    }

    public static boolean valueAsBoolean(String rawValue) {
        return Boolean.parseBoolean(rawValue);
    }

    public static int valueAsInteger(String rawValue) {
        try {
            return Integer.parseInt(rawValue);
        }
        catch (NumberFormatException e) {
            throw new ModelTypeException(rawValue, (Type)((Object)Integer.class));
        }
    }

    public static float valueAsFloat(String rawValue) {
        try {
            return Float.parseFloat(rawValue);
        }
        catch (NumberFormatException e) {
            throw new ModelTypeException(rawValue, (Type)((Object)Float.class));
        }
    }

    public static double valueAsDouble(String rawValue) {
        try {
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            throw new ModelTypeException(rawValue, (Type)((Object)Double.class));
        }
    }

    public static short valueAsShort(String rawValue) {
        try {
            return Short.parseShort(rawValue);
        }
        catch (NumberFormatException e) {
            throw new ModelTypeException(rawValue, (Type)((Object)Short.class));
        }
    }

    public static String valueAsString(boolean booleanValue) {
        return Boolean.toString(booleanValue);
    }

    public static String valueAsString(int integerValue) {
        return Integer.toString(integerValue);
    }

    public static String valueAsString(float floatValue) {
        return Float.toString(floatValue);
    }

    public static String valueAsString(double doubleValue) {
        return Double.toString(doubleValue);
    }

    public static String valueAsString(short shortValue) {
        return Short.toString(shortValue);
    }

    public static <T extends ModelElementInstance> Collection<T> getModelElementCollection(Collection<DomElement> view, ModelInstanceImpl model) {
        ArrayList<ModelElementInstance> resultList = new ArrayList<ModelElementInstance>();
        for (DomElement element : view) {
            resultList.add(ModelUtil.getModelElement(element, model));
        }
        return resultList;
    }

    public static int getIndexOfElementType(ModelElementInstance modelElement, List<ModelElementType> childElementTypes) {
        for (int index = 0; index < childElementTypes.size(); ++index) {
            ModelElementType childElementType = childElementTypes.get(index);
            Class<? extends ModelElementInstance> instanceType = childElementType.getInstanceType();
            if (!instanceType.isAssignableFrom(modelElement.getClass())) continue;
            return index;
        }
        ArrayList<String> childElementTypeNames = new ArrayList<String>();
        for (ModelElementType childElementType : childElementTypes) {
            childElementTypeNames.add(childElementType.getTypeName());
        }
        throw new ModelException("New child is not a valid child element type: " + modelElement.getElementType().getTypeName() + "; valid types are: " + String.valueOf(childElementTypeNames));
    }

    public static Collection<ModelElementType> calculateAllExtendingTypes(Model model, Collection<ModelElementType> baseTypes) {
        HashSet<ModelElementType> allExtendingTypes = new HashSet<ModelElementType>();
        for (ModelElementType baseType : baseTypes) {
            ModelElementTypeImpl modelElementTypeImpl = (ModelElementTypeImpl)model.getType(baseType.getInstanceType());
            modelElementTypeImpl.resolveExtendingTypes(allExtendingTypes);
        }
        return allExtendingTypes;
    }

    public static Collection<ModelElementType> calculateAllBaseTypes(ModelElementType type) {
        ArrayList<ModelElementType> baseTypes = new ArrayList<ModelElementType>();
        ModelElementTypeImpl typeImpl = (ModelElementTypeImpl)type;
        typeImpl.resolveBaseTypes(baseTypes);
        return baseTypes;
    }

    public static void setNewIdentifier(ModelElementType type, ModelElementInstance modelElementInstance, String newId, boolean withReferenceUpdate) {
        Attribute<?> id = type.getAttribute(ID_ATTRIBUTE_NAME);
        if (id instanceof StringAttribute) {
            StringAttribute stringAttr = (StringAttribute)id;
            if (id.isIdAttribute()) {
                stringAttr.setValue(modelElementInstance, newId, withReferenceUpdate);
            }
        }
    }

    public static void setGeneratedUniqueIdentifier(ModelElementType type, ModelElementInstance modelElementInstance) {
        ModelUtil.setGeneratedUniqueIdentifier(type, modelElementInstance, true);
    }

    public static void setGeneratedUniqueIdentifier(ModelElementType type, ModelElementInstance modelElementInstance, boolean withReferenceUpdate) {
        ModelUtil.setNewIdentifier(type, modelElementInstance, ModelUtil.getUniqueIdentifier(type), withReferenceUpdate);
    }

    public static String getUniqueIdentifier(ModelElementType type) {
        return type.getTypeName() + "_" + String.valueOf(UUID.randomUUID());
    }
}

