/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.model.xml.impl.validation;

import io.openbpm.bpm.model.xml.impl.ModelInstanceImpl;
import io.openbpm.bpm.model.xml.impl.validation.ValidationResultsCollectorImpl;
import io.openbpm.bpm.model.xml.instance.ModelElementInstance;
import io.openbpm.bpm.model.xml.validation.ModelElementValidator;
import io.openbpm.bpm.model.xml.validation.ValidationResults;
import java.util.Collection;

public class ModelInstanceValidator {
    protected ModelInstanceImpl modelInstanceImpl;
    protected Collection<ModelElementValidator<?>> validators;

    public ModelInstanceValidator(ModelInstanceImpl modelInstanceImpl, Collection<ModelElementValidator<?>> validators) {
        this.modelInstanceImpl = modelInstanceImpl;
        this.validators = validators;
    }

    public ValidationResults validate() {
        ValidationResultsCollectorImpl resultsCollector = new ValidationResultsCollectorImpl();
        for (ModelElementValidator<?> validator : this.validators) {
            Class<?> elementType = validator.getElementType();
            Collection<?> modelElementsByType = this.modelInstanceImpl.getModelElementsByType(elementType);
            for (ModelElementInstance element : modelElementsByType) {
                resultsCollector.setCurrentElement(element);
                try {
                    validator.validate(element, resultsCollector);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Validator " + String.valueOf(validator) + " threw an exception while validating " + String.valueOf(element), e);
                }
            }
        }
        return resultsCollector.getResults();
    }
}

