/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.commons.utils.cache;

import io.openbpm.commons.utils.cache.Cache;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentLruCache<K, V>
implements Cache<K, V> {
    private final int capacity;
    private final ConcurrentMap<K, V> cache = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<K> keys = new ConcurrentLinkedQueue();

    public ConcurrentLruCache(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
    }

    @Override
    public V get(K key) {
        Object value = this.cache.get(key);
        if (value != null) {
            this.keys.remove(key);
            this.keys.add(key);
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        K lruKey;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        V previousValue = this.cache.put(key, value);
        if (previousValue != null) {
            this.keys.remove(key);
        }
        this.keys.add(key);
        if (this.cache.size() > this.capacity && (lruKey = this.keys.poll()) != null) {
            this.cache.remove(lruKey);
            this.removeAll(lruKey);
            if (this.cache.containsKey(lruKey)) {
                this.keys.add(lruKey);
            }
        }
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
        this.keys.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.keys.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    protected void removeAll(K key) {
        while (this.keys.remove(key)) {
        }
    }
}

