/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.impl.util;

import io.openbpm.commons.utils.IoUtil;
import io.openbpm.spin.impl.logging.SpinCoreLogger;
import io.openbpm.spin.impl.logging.SpinLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class SpinIoUtil
extends IoUtil {
    public static final Charset ENCODING_CHARSET = StandardCharsets.UTF_8;
    private static final SpinCoreLogger LOG = SpinLogger.CORE_LOGGER;

    public static InputStream convertOutputStreamToInputStream(OutputStream outputStream) {
        byte[] data = ((ByteArrayOutputStream)outputStream).toByteArray();
        return new ByteArrayInputStream(data);
    }

    public static String getStringFromInputStream(InputStream inputStream) throws IOException {
        return SpinIoUtil.getStringFromInputStream(inputStream, true);
    }

    public static String getStringFromInputStream(InputStream inputStream, boolean trim) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (trim) {
                    stringBuilder.append(line.trim());
                    continue;
                }
                stringBuilder.append(line).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public static String getStringFromReader(Reader reader) throws IOException {
        return SpinIoUtil.getStringFromReader(reader, true);
    }

    public static String getStringFromReader(Reader reader, boolean trim) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (trim) {
                    stringBuilder.append(line.trim());
                    continue;
                }
                stringBuilder.append(line).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public static Reader classpathResourceAsReader(String fileName) {
        try {
            File classpathFile = SpinIoUtil.getClasspathFile((String)fileName);
            return new FileReader(classpathFile);
        }
        catch (FileNotFoundException e) {
            throw LOG.fileNotFoundException(fileName, e);
        }
    }

    public static Reader stringAsReader(String string) {
        return new StringReader(string);
    }
}

