/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.plugin.impl;

import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.context.Context;
import io.openbpm.bpm.engine.impl.util.IoUtil;
import io.openbpm.bpm.engine.impl.variable.serializer.AbstractObjectValueSerializer;
import io.openbpm.spin.DeserializationTypeValidator;
import io.openbpm.spin.spi.DataFormat;
import io.openbpm.spin.spi.DataFormatMapper;
import io.openbpm.spin.spi.DataFormatReader;
import io.openbpm.spin.spi.DataFormatWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;

public class SpinObjectValueSerializer
extends AbstractObjectValueSerializer {
    protected String name;
    protected DataFormat<?> dataFormat;
    protected DeserializationTypeValidator validator;

    public SpinObjectValueSerializer(String name, DataFormat<?> dataFormat) {
        super(dataFormat.getName());
        this.name = name;
        this.dataFormat = dataFormat;
    }

    public String getName() {
        return this.name;
    }

    protected boolean isSerializationTextBased() {
        return true;
    }

    protected String getTypeNameForDeserialized(Object deserializedObject) {
        return this.dataFormat.getMapper().getCanonicalTypeName(deserializedObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serializeToByteArray(Object deserializedObject) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        Objects.requireNonNull(processEngineConfiguration);
        DataFormatMapper mapper = this.dataFormat.getMapper();
        DataFormatWriter writer = this.dataFormat.getWriter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out, processEngineConfiguration.getDefaultCharset());
        BufferedWriter bufferedWriter = new BufferedWriter(outWriter);
        try {
            Object mappedObject = mapper.mapJavaToInternal(deserializedObject);
            writer.writeToWriter((Writer)bufferedWriter, mappedObject);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            IoUtil.closeSilently((Closeable)out);
            IoUtil.closeSilently((Closeable)outWriter);
            IoUtil.closeSilently((Closeable)bufferedWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeFromByteArray(byte[] bytes, String objectTypeName) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        Objects.requireNonNull(processEngineConfiguration);
        DataFormatMapper mapper = this.dataFormat.getMapper();
        DataFormatReader reader = this.dataFormat.getReader();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        InputStreamReader inReader = new InputStreamReader((InputStream)bais, processEngineConfiguration.getDefaultCharset());
        BufferedReader bufferedReader = new BufferedReader(inReader);
        try {
            Object mappedObject = reader.readInput((Reader)bufferedReader);
            Object object = mapper.mapInternalToJava(mappedObject, objectTypeName, this.getValidator(processEngineConfiguration));
            return object;
        }
        finally {
            IoUtil.closeSilently((Closeable)bais);
            IoUtil.closeSilently((Closeable)inReader);
            IoUtil.closeSilently((Closeable)bufferedReader);
        }
    }

    protected boolean canSerializeValue(Object value) {
        return this.dataFormat.getMapper().canMap(value);
    }

    protected DeserializationTypeValidator getValidator(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (this.validator == null && processEngineConfiguration.isDeserializationTypeValidationEnabled()) {
            this.validator = type -> processEngineConfiguration.getDeserializationTypeValidator().validate(type);
        }
        return this.validator;
    }
}

