/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto;

import io.openbpm.bpm.engine.AuthorizationException;
import io.openbpm.bpm.engine.rest.dto.ExceptionDto;
import io.openbpm.bpm.engine.rest.dto.MissingAuthorizationDto;
import java.util.List;

public class AuthorizationExceptionDto
extends ExceptionDto {
    protected String userId;
    protected String resourceName;
    protected String resourceId;
    protected String permissionName;
    protected List<MissingAuthorizationDto> missingAuthorizations;

    public static AuthorizationExceptionDto fromException(AuthorizationException e) {
        AuthorizationExceptionDto dto = new AuthorizationExceptionDto();
        dto.setMessage(e.getMessage());
        dto.setType(AuthorizationException.class.getSimpleName());
        dto.setUserId(e.getUserId());
        dto.setMissingAuthorizations(MissingAuthorizationDto.fromInfo(e.getMissingAuthorizations()));
        dto.setPermissionName(e.getViolatedPermissionName());
        dto.setResourceId(e.getResourceId());
        dto.setResourceName(e.getResourceType());
        return dto;
    }

    @Deprecated(forRemoval=true, since="1.0")
    public String getResourceName() {
        return this.resourceName;
    }

    @Deprecated(forRemoval=true, since="1.0")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @Deprecated(forRemoval=true, since="1.0")
    public String getResourceId() {
        return this.resourceId;
    }

    @Deprecated(forRemoval=true, since="1.0")
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Deprecated(forRemoval=true, since="1.0")
    public String getPermissionName() {
        return this.permissionName;
    }

    @Deprecated(forRemoval=true, since="1.0")
    public void setPermissionName(String permissionName) {
        this.permissionName = permissionName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public List<MissingAuthorizationDto> getMissingAuthorizations() {
        return this.missingAuthorizations;
    }

    public void setMissingAuthorizations(List<MissingAuthorizationDto> info) {
        this.missingAuthorizations = info;
    }
}

