/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.batch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.batch.BatchQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.commons.utils.CollectionUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BatchQueryDto
extends AbstractQueryDto<BatchQuery> {
    private static final String SORT_BY_BATCH_ID_VALUE = "batchId";
    private static final String SORT_BY_TENANT_ID_VALUE = "tenantId";
    protected String batchId;
    protected String type;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean suspended;
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();

    public BatchQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="batchId")
    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @OperatonQueryParam(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OperatonQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected BatchQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createBatchQuery();
    }

    @Override
    protected void applyFilters(BatchQuery query) {
        Optional.ofNullable(this.batchId).ifPresent(arg_0 -> ((BatchQuery)query).batchId(arg_0));
        Optional.ofNullable(this.type).ifPresent(arg_0 -> ((BatchQuery)query).type(arg_0));
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (CollectionUtil.hasElements(this.tenantIds)) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.suspended)) {
            query.suspended();
        }
        if (Boolean.FALSE.equals(this.suspended)) {
            query.active();
        }
    }

    @Override
    protected void applySortBy(BatchQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_BATCH_ID_VALUE.equals(sortBy)) {
            query.orderById();
        } else if (SORT_BY_TENANT_ID_VALUE.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_BATCH_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID_VALUE);
    }
}

