/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.rest.dto.converter.StringToTypeConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.Response;

public abstract class JacksonAwareStringToTypeConverter<T>
implements StringToTypeConverter<T> {
    protected ObjectMapper objectMapper;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected T mapToType(String value, Class<T> typeClass) {
        try {
            return (T)this.objectMapper.readValue(value, typeClass);
        }
        catch (JsonProcessingException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Cannot convert value %s to java type %s".formatted(value, typeClass.getName()));
        }
    }
}

