/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricActivityInstanceQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HistoricActivityInstanceQueryDto
extends AbstractQueryDto<HistoricActivityInstanceQuery> {
    protected static final String SORT_BY_HISTORIC_ACTIVITY_INSTANCE_ID_VALUE = "activityInstanceId";
    protected static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    protected static final String SORT_BY_EXECUTION_ID_VALUE = "executionId";
    protected static final String SORT_BY_ACTIVITY_ID_VALUE = "activityId";
    protected static final String SORT_BY_ACTIVITY_NAME_VALUE = "activityName";
    protected static final String SORT_BY_ACTIVITY_TYPE_VALUE = "activityType";
    protected static final String SORT_BY_HISTORIC_ACTIVITY_INSTANCE_START_TIME_VALUE = "startTime";
    protected static final String SORT_BY_HISTORIC_ACTIVITY_INSTANCE_END_TIME_VALUE = "endTime";
    protected static final String SORT_BY_HISTORIC_ACTIVITY_INSTANCE_DURATION_VALUE = "duration";
    protected static final String SORT_BY_PROCESS_DEFINITION_ID_VALUE = "definitionId";
    protected static final String SORT_PARTIALLY_BY_OCCURRENCE = "occurrence";
    protected static final String SORT_BY_TENANT_ID = "tenantId";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String activityInstanceId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String executionId;
    protected String activityId;
    protected String activityName;
    protected String activityNameLike;
    protected String activityType;
    protected String taskAssignee;
    protected Boolean finished;
    protected Boolean unfinished;
    protected Boolean completeScope;
    protected Boolean canceled;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Date finishedBefore;
    protected Date finishedAfter;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;

    public HistoricActivityInstanceQueryDto() {
    }

    public HistoricActivityInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="activityInstanceId")
    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @OperatonQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @OperatonQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @OperatonQueryParam(value="activityName")
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    @OperatonQueryParam(value="activityNameLike")
    public void setActivityNameLike(String activityNameLike) {
        this.activityNameLike = activityNameLike;
    }

    @OperatonQueryParam(value="activityType")
    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    @OperatonQueryParam(value="taskAssignee")
    public void setTaskAssignee(String taskAssignee) {
        this.taskAssignee = taskAssignee;
    }

    @OperatonQueryParam(value="finished", converter=BooleanConverter.class)
    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @OperatonQueryParam(value="unfinished", converter=BooleanConverter.class)
    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    @OperatonQueryParam(value="completeScope", converter=BooleanConverter.class)
    public void setCompleteScope(Boolean completeScope) {
        this.completeScope = completeScope;
    }

    @OperatonQueryParam(value="canceled", converter=BooleanConverter.class)
    public void setCanceled(Boolean canceled) {
        this.canceled = canceled;
    }

    @OperatonQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @OperatonQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @OperatonQueryParam(value="finishedBefore", converter=DateConverter.class)
    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    @OperatonQueryParam(value="finishedAfter", converter=DateConverter.class)
    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricActivityInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricActivityInstanceQuery();
    }

    @Override
    protected void applyFilters(HistoricActivityInstanceQuery query) {
        if (this.activityInstanceId != null) {
            query.activityInstanceId(this.activityInstanceId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.activityName != null) {
            query.activityName(this.activityName);
        }
        if (this.activityNameLike != null) {
            query.activityNameLike(this.activityNameLike);
        }
        if (this.activityType != null) {
            query.activityType(this.activityType);
        }
        if (this.taskAssignee != null) {
            query.taskAssignee(this.taskAssignee);
        }
        if (this.finished != null && this.finished.booleanValue()) {
            query.finished();
        }
        if (this.unfinished != null && this.unfinished.booleanValue()) {
            query.unfinished();
        }
        if (this.completeScope != null && this.completeScope.booleanValue()) {
            query.completeScope();
        }
        if (this.canceled != null && this.canceled.booleanValue()) {
            query.canceled();
        }
        if (this.startedBefore != null) {
            query.startedBefore(this.startedBefore);
        }
        if (this.startedAfter != null) {
            query.startedAfter(this.startedAfter);
        }
        if (this.finishedBefore != null) {
            query.finishedBefore(this.finishedBefore);
        }
        if (this.finishedAfter != null) {
            query.finishedAfter(this.finishedAfter);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
    }

    @Override
    protected void applySortBy(HistoricActivityInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_HISTORIC_ACTIVITY_INSTANCE_ID_VALUE.equals(sortBy)) {
            query.orderByHistoricActivityInstanceId();
        } else if (SORT_BY_PROCESS_INSTANCE_ID_VALUE.equals(sortBy)) {
            query.orderByProcessInstanceId();
        } else if (SORT_BY_PROCESS_DEFINITION_ID_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionId();
        } else if (SORT_BY_EXECUTION_ID_VALUE.equals(sortBy)) {
            query.orderByExecutionId();
        } else if (SORT_BY_ACTIVITY_ID_VALUE.equals(sortBy)) {
            query.orderByActivityId();
        } else if (SORT_BY_ACTIVITY_NAME_VALUE.equals(sortBy)) {
            query.orderByActivityName();
        } else if (SORT_BY_ACTIVITY_TYPE_VALUE.equals(sortBy)) {
            query.orderByActivityType();
        } else if (SORT_BY_HISTORIC_ACTIVITY_INSTANCE_START_TIME_VALUE.equals(sortBy)) {
            query.orderByHistoricActivityInstanceStartTime();
        } else if (SORT_BY_HISTORIC_ACTIVITY_INSTANCE_END_TIME_VALUE.equals(sortBy)) {
            query.orderByHistoricActivityInstanceEndTime();
        } else if (SORT_BY_HISTORIC_ACTIVITY_INSTANCE_DURATION_VALUE.equals(sortBy)) {
            query.orderByHistoricActivityInstanceDuration();
        } else if (SORT_PARTIALLY_BY_OCCURRENCE.equals(sortBy)) {
            query.orderPartiallyByOccurrence();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORIC_ACTIVITY_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_TYPE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORIC_ACTIVITY_INSTANCE_START_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORIC_ACTIVITY_INSTANCE_END_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_HISTORIC_ACTIVITY_INSTANCE_DURATION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_PARTIALLY_BY_OCCURRENCE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

