/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricIdentityLinkLogQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class HistoricIdentityLinkLogQueryDto
extends AbstractQueryDto<HistoricIdentityLinkLogQuery> {
    private static final String SORT_BY_TIME = "time";
    private static final String SORT_BY_TYPE = "type";
    private static final String SORT_BY_USER_ID = "userId";
    private static final String SORT_BY_GROUP_ID = "groupId";
    private static final String SORT_BY_TASK_ID = "taskId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private static final String SORT_BY_OPERATION_TYPE = "operationType";
    private static final String SORT_BY_ASSIGNER_ID = "assignerId";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected Date dateBefore;
    protected Date dateAfter;
    protected String type;
    protected String userId;
    protected String groupId;
    protected String taskId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String operationType;
    protected String assignerId;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;

    public HistoricIdentityLinkLogQueryDto() {
    }

    public HistoricIdentityLinkLogQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricIdentityLinkLogQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricIdentityLinkLogQuery();
    }

    @OperatonQueryParam(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @OperatonQueryParam(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @OperatonQueryParam(value="groupId")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @OperatonQueryParam(value="dateBefore", converter=DateConverter.class)
    public void setDateBefore(Date dateBefore) {
        this.dateBefore = dateBefore;
    }

    @OperatonQueryParam(value="dateAfter", converter=DateConverter.class)
    public void setDateAfter(Date dateAfter) {
        this.dateAfter = dateAfter;
    }

    @OperatonQueryParam(value="taskId")
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OperatonQueryParam(value="operationType")
    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    @OperatonQueryParam(value="assignerId")
    public void setAssignerId(String assignerId) {
        this.assignerId = assignerId;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @Override
    protected void applyFilters(HistoricIdentityLinkLogQuery query) {
        if (this.dateBefore != null) {
            query.dateBefore(this.dateBefore);
        }
        if (this.dateAfter != null) {
            query.dateAfter(this.dateAfter);
        }
        if (this.type != null) {
            query.type(this.type);
        }
        if (this.userId != null) {
            query.userId(this.userId);
        }
        if (this.groupId != null) {
            query.groupId(this.groupId);
        }
        if (this.taskId != null) {
            query.taskId(this.taskId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.operationType != null) {
            query.operationType(this.operationType);
        }
        if (this.assignerId != null) {
            query.assignerId(this.assignerId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
    }

    @Override
    protected void applySortBy(HistoricIdentityLinkLogQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_TIME.equals(sortBy)) {
            query.orderByTime();
        } else if (SORT_BY_TYPE.equals(sortBy)) {
            query.orderByType();
        } else if (SORT_BY_USER_ID.equals(sortBy)) {
            query.orderByUserId();
        } else if (SORT_BY_GROUP_ID.equals(sortBy)) {
            query.orderByGroupId();
        } else if (SORT_BY_TASK_ID.equals(sortBy)) {
            query.orderByTaskId();
        } else if (SORT_BY_OPERATION_TYPE.equals(sortBy)) {
            query.orderByOperationType();
        } else if (SORT_BY_ASSIGNER_ID.equals(sortBy)) {
            query.orderByAssignerId();
        } else if (SORT_BY_PROCESS_DEFINITION_ID.equals(sortBy)) {
            query.orderByProcessDefinitionId();
        } else if (SORT_BY_PROCESS_DEFINITION_KEY.equals(sortBy)) {
            query.orderByProcessDefinitionKey();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_USER_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_GROUP_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_TASK_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_OPERATION_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ASSIGNER_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

