/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricProcessInstanceQuery;
import io.openbpm.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.VariableQueryParameterDto;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringSetConverter;
import io.openbpm.bpm.engine.rest.dto.converter.VariableListConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HistoricProcessInstanceQueryDto
extends AbstractQueryDto<HistoricProcessInstanceQuery> {
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "instanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID_VALUE = "definitionId";
    private static final String SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE = "businessKey";
    private static final String SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE = "startTime";
    private static final String SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE = "endTime";
    private static final String SORT_BY_PROCESS_INSTANCE_DURATION_VALUE = "duration";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY_VALUE = "definitionKey";
    private static final String SORT_BY_PROCESS_DEFINITION_NAME_VALUE = "definitionName";
    private static final String SORT_BY_PROCESS_DEFINITION_VERSION_VALUE = "definitionVersion";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    private String processInstanceId;
    private Set<String> processInstanceIds;
    private List<String> processInstanceIdNotIn;
    private String rootProcessInstanceId;
    private String processDefinitionId;
    private String processDefinitionKey;
    private List<String> processDefinitionKeys;
    private String processDefinitionName;
    private String processDefinitionNameLike;
    private List<String> processDefinitionKeyNotIn;
    private String processInstanceBusinessKey;
    private List<String> processInstanceBusinessKeyIn;
    private String processInstanceBusinessKeyLike;
    private Boolean rootProcessInstances;
    private Boolean finished;
    private Boolean unfinished;
    private Boolean withJobsRetrying;
    private Boolean withIncidents;
    private Boolean withRootIncidents;
    private String incidentType;
    private String incidentStatus;
    private String incidentMessage;
    private String incidentMessageLike;
    private Date startedBefore;
    private Date startedAfter;
    private Date finishedBefore;
    private Date finishedAfter;
    private Date executedActivityAfter;
    private Date executedActivityBefore;
    private Date executedJobAfter;
    private Date executedJobBefore;
    private String startedBy;
    private String superProcessInstanceId;
    private String subProcessInstanceId;
    private String superCaseInstanceId;
    private String subCaseInstanceId;
    private String caseInstanceId;
    private List<String> tenantIds;
    private Boolean withoutTenantId;
    private List<String> executedActivityIdIn;
    private List<String> activeActivityIdIn;
    private List<String> activityIdIn;
    private Boolean active;
    private Boolean suspended;
    private Boolean completed;
    private Boolean externallyTerminated;
    private Boolean internallyTerminated;
    private List<String> incidentIds;
    private List<VariableQueryParameterDto> variables;
    protected Boolean variableNamesIgnoreCase;
    protected Boolean variableValuesIgnoreCase;
    private List<HistoricProcessInstanceQueryDto> orQueries;

    public HistoricProcessInstanceQueryDto() {
    }

    public HistoricProcessInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="orQueries")
    public void setOrQueries(List<HistoricProcessInstanceQueryDto> orQueries) {
        this.orQueries = orQueries;
    }

    @OperatonQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OperatonQueryParam(value="processInstanceIds", converter=StringSetConverter.class)
    public void setProcessInstanceIds(Set<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @OperatonQueryParam(value="processInstanceIdNotIn", converter=StringListConverter.class)
    public void setProcessInstanceIdNotIn(List<String> processInstanceIdNotIn) {
        this.processInstanceIdNotIn = processInstanceIdNotIn;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    @OperatonQueryParam(value="rootProcessInstanceId")
    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionName")
    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    @OperatonQueryParam(value="processDefinitionNameLike")
    public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
        this.processDefinitionNameLike = processDefinitionNameLike;
    }

    @OperatonQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OperatonQueryParam(value="processDefinitionKeyIn", converter=StringListConverter.class)
    public void setProcessDefinitionKeyIn(List<String> processDefinitionKeys) {
        this.processDefinitionKeys = processDefinitionKeys;
    }

    @OperatonQueryParam(value="processDefinitionKeyNotIn", converter=StringListConverter.class)
    public void setProcessDefinitionKeyNotIn(List<String> processDefinitionKeys) {
        this.processDefinitionKeyNotIn = processDefinitionKeys;
    }

    @OperatonQueryParam(value="processInstanceBusinessKey")
    public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
    }

    @OperatonQueryParam(value="processInstanceBusinessKeyIn", converter=StringListConverter.class)
    public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
        this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
    }

    @OperatonQueryParam(value="processInstanceBusinessKeyLike")
    public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
        this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
    }

    @OperatonQueryParam(value="rootProcessInstances", converter=BooleanConverter.class)
    public void setRootProcessInstances(Boolean rootProcessInstances) {
        this.rootProcessInstances = rootProcessInstances;
    }

    @OperatonQueryParam(value="finished", converter=BooleanConverter.class)
    public void setFinished(Boolean finished) {
        this.finished = finished;
    }

    @OperatonQueryParam(value="unfinished", converter=BooleanConverter.class)
    public void setUnfinished(Boolean unfinished) {
        this.unfinished = unfinished;
    }

    @OperatonQueryParam(value="withJobsRetrying", converter=BooleanConverter.class)
    public void setWithJobsRetrying(Boolean withJobsRetrying) {
        this.withJobsRetrying = withJobsRetrying;
    }

    @OperatonQueryParam(value="withIncidents", converter=BooleanConverter.class)
    public void setWithIncidents(Boolean withIncidents) {
        this.withIncidents = withIncidents;
    }

    @OperatonQueryParam(value="withRootIncidents", converter=BooleanConverter.class)
    public void setWithRootIncidents(Boolean withRootIncidents) {
        this.withRootIncidents = withRootIncidents;
    }

    @OperatonQueryParam(value="incidentStatus")
    public void setIncidentStatus(String status) {
        this.incidentStatus = status;
    }

    @OperatonQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @OperatonQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    @OperatonQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @OperatonQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @OperatonQueryParam(value="finishedBefore", converter=DateConverter.class)
    public void setFinishedBefore(Date finishedBefore) {
        this.finishedBefore = finishedBefore;
    }

    @OperatonQueryParam(value="finishedAfter", converter=DateConverter.class)
    public void setFinishedAfter(Date finishedAfter) {
        this.finishedAfter = finishedAfter;
    }

    @OperatonQueryParam(value="startedBy")
    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    @OperatonQueryParam(value="superProcessInstanceId")
    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    @OperatonQueryParam(value="subProcessInstanceId")
    public void setSubProcessInstanceId(String subProcessInstanceId) {
        this.subProcessInstanceId = subProcessInstanceId;
    }

    @OperatonQueryParam(value="superCaseInstanceId")
    public void setSuperCaseInstanceId(String superCaseInstanceId) {
        this.superCaseInstanceId = superCaseInstanceId;
    }

    @OperatonQueryParam(value="subCaseInstanceId")
    public void setSubCaseInstanceId(String subCaseInstanceId) {
        this.subCaseInstanceId = subCaseInstanceId;
    }

    @OperatonQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @OperatonQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    @OperatonQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @OperatonQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    @OperatonQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @OperatonQueryParam(value="incidentIdIn", converter=StringListConverter.class)
    public void setIncidentIdIn(List<String> incidentIds) {
        this.incidentIds = incidentIds;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OperatonQueryParam(value="executedActivityAfter", converter=DateConverter.class)
    public void setExecutedActivityAfter(Date executedActivityAfter) {
        this.executedActivityAfter = executedActivityAfter;
    }

    @OperatonQueryParam(value="executedActivityIdIn", converter=StringListConverter.class)
    public void setExecutedActivityIdIn(List<String> executedActivityIds) {
        this.executedActivityIdIn = executedActivityIds;
    }

    @OperatonQueryParam(value="executedActivityBefore", converter=DateConverter.class)
    public void setExecutedActivityBefore(Date executedActivityBefore) {
        this.executedActivityBefore = executedActivityBefore;
    }

    @OperatonQueryParam(value="activeActivityIdIn", converter=StringListConverter.class)
    public void setActiveActivityIdIn(List<String> activeActivityIdIn) {
        this.activeActivityIdIn = activeActivityIdIn;
    }

    @OperatonQueryParam(value="activityIdIn", converter=StringListConverter.class)
    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    @OperatonQueryParam(value="executedJobAfter", converter=DateConverter.class)
    public void setExecutedJobAfter(Date executedJobAfter) {
        this.executedJobAfter = executedJobAfter;
    }

    @OperatonQueryParam(value="executedJobBefore", converter=DateConverter.class)
    public void setExecutedJobBefore(Date executedJobBefore) {
        this.executedJobBefore = executedJobBefore;
    }

    @OperatonQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @OperatonQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @OperatonQueryParam(value="completed", converter=BooleanConverter.class)
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @OperatonQueryParam(value="externallyTerminated", converter=BooleanConverter.class)
    public void setExternallyTerminated(Boolean externallyTerminated) {
        this.externallyTerminated = externallyTerminated;
    }

    @OperatonQueryParam(value="internallyTerminated", converter=BooleanConverter.class)
    public void setInternallyTerminated(Boolean internallyTerminated) {
        this.internallyTerminated = internallyTerminated;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricProcessInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricProcessInstanceQuery();
    }

    public List<HistoricProcessInstanceQueryDto> getOrQueries() {
        return this.orQueries;
    }

    @Override
    protected void applyFilters(HistoricProcessInstanceQuery query) {
        if (this.orQueries != null) {
            for (HistoricProcessInstanceQueryDto orQueryDto : this.orQueries) {
                HistoricProcessInstanceQueryImpl orQuery = new HistoricProcessInstanceQueryImpl();
                orQuery.setOrQueryActive();
                orQueryDto.applyFilters((HistoricProcessInstanceQuery)orQuery);
                ((HistoricProcessInstanceQueryImpl)query).addOrQuery(orQuery);
            }
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processInstanceIds != null) {
            query.processInstanceIds(this.processInstanceIds);
        }
        if (this.processInstanceIdNotIn != null && !this.processInstanceIdNotIn.isEmpty()) {
            query.processInstanceIdNotIn(this.processInstanceIdNotIn.toArray(new String[0]));
        }
        if (this.rootProcessInstanceId != null) {
            query.rootProcessInstanceId(this.rootProcessInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processDefinitionKeys != null && !this.processDefinitionKeys.isEmpty()) {
            query.processDefinitionKeyIn(this.processDefinitionKeys.toArray(new String[0]));
        }
        if (this.processDefinitionName != null) {
            query.processDefinitionName(this.processDefinitionName);
        }
        if (this.processDefinitionNameLike != null) {
            query.processDefinitionNameLike(this.processDefinitionNameLike);
        }
        if (this.processDefinitionKeyNotIn != null) {
            query.processDefinitionKeyNotIn(this.processDefinitionKeyNotIn);
        }
        if (this.processInstanceBusinessKey != null) {
            query.processInstanceBusinessKey(this.processInstanceBusinessKey);
        }
        if (this.processInstanceBusinessKeyIn != null && !this.processInstanceBusinessKeyIn.isEmpty()) {
            query.processInstanceBusinessKeyIn(this.processInstanceBusinessKeyIn.toArray(new String[0]));
        }
        if (this.processInstanceBusinessKeyLike != null) {
            query.processInstanceBusinessKeyLike(this.processInstanceBusinessKeyLike);
        }
        if (this.rootProcessInstances != null && this.rootProcessInstances.booleanValue()) {
            query.rootProcessInstances();
        }
        if (this.finished != null && this.finished.booleanValue()) {
            query.finished();
        }
        if (this.unfinished != null && this.unfinished.booleanValue()) {
            query.unfinished();
        }
        if (this.withJobsRetrying != null && this.withJobsRetrying.booleanValue()) {
            query.withJobsRetrying();
        }
        if (this.withIncidents != null && this.withIncidents.booleanValue()) {
            query.withIncidents();
        }
        if (this.withRootIncidents != null && this.withRootIncidents.booleanValue()) {
            query.withRootIncidents();
        }
        if (this.incidentIds != null && !this.incidentIds.isEmpty()) {
            query.incidentIdIn(this.incidentIds.toArray(new String[0]));
        }
        if (this.incidentStatus != null) {
            query.incidentStatus(this.incidentStatus);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.startedBefore != null) {
            query.startedBefore(this.startedBefore);
        }
        if (this.startedAfter != null) {
            query.startedAfter(this.startedAfter);
        }
        if (this.finishedBefore != null) {
            query.finishedBefore(this.finishedBefore);
        }
        if (this.finishedAfter != null) {
            query.finishedAfter(this.finishedAfter);
        }
        if (this.startedBy != null) {
            query.startedBy(this.startedBy);
        }
        if (this.superProcessInstanceId != null) {
            query.superProcessInstanceId(this.superProcessInstanceId);
        }
        if (this.subProcessInstanceId != null) {
            query.subProcessInstanceId(this.subProcessInstanceId);
        }
        if (this.superCaseInstanceId != null) {
            query.superCaseInstanceId(this.superCaseInstanceId);
        }
        if (this.subCaseInstanceId != null) {
            query.subCaseInstanceId(this.subCaseInstanceId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[0]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if ("eq".equals(op)) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if ("gt".equals(op)) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if ("gteq".equals(op)) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if ("lt".equals(op)) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if ("lteq".equals(op)) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if ("neq".equals(op)) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if ("like".equals(op)) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
        if (this.executedActivityAfter != null) {
            query.executedActivityAfter(this.executedActivityAfter);
        }
        if (this.executedActivityBefore != null) {
            query.executedActivityBefore(this.executedActivityBefore);
        }
        if (this.executedActivityIdIn != null && !this.executedActivityIdIn.isEmpty()) {
            query.executedActivityIdIn(this.executedActivityIdIn.toArray(new String[0]));
        }
        if (this.activeActivityIdIn != null && !this.activeActivityIdIn.isEmpty()) {
            query.activeActivityIdIn(this.activeActivityIdIn.toArray(new String[0]));
        }
        if (this.activityIdIn != null && !this.activityIdIn.isEmpty()) {
            query.activityIdIn(this.activityIdIn.toArray(new String[0]));
        }
        if (this.executedJobAfter != null) {
            query.executedJobAfter(this.executedJobAfter);
        }
        if (this.executedJobBefore != null) {
            query.executedJobBefore(this.executedJobBefore);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.completed != null && this.completed.booleanValue()) {
            query.completed();
        }
        if (this.externallyTerminated != null && this.externallyTerminated.booleanValue()) {
            query.externallyTerminated();
        }
        if (this.internallyTerminated != null && this.internallyTerminated.booleanValue()) {
            query.internallyTerminated();
        }
    }

    @Override
    protected void applySortBy(HistoricProcessInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_PROCESS_INSTANCE_ID_VALUE.equals(sortBy)) {
            query.orderByProcessInstanceId();
        } else if (SORT_BY_PROCESS_DEFINITION_ID_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionId();
        } else if (SORT_BY_PROCESS_DEFINITION_KEY_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionKey();
        } else if (SORT_BY_PROCESS_DEFINITION_NAME_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionName();
        } else if (SORT_BY_PROCESS_DEFINITION_VERSION_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionVersion();
        } else if (SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE.equals(sortBy)) {
            query.orderByProcessInstanceBusinessKey();
        } else if (SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE.equals(sortBy)) {
            query.orderByProcessInstanceStartTime();
        } else if (SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE.equals(sortBy)) {
            query.orderByProcessInstanceEndTime();
        } else if (SORT_BY_PROCESS_INSTANCE_DURATION_VALUE.equals(sortBy)) {
            query.orderByProcessInstanceDuration();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_BUSINESS_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_START_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_END_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_DURATION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_VERSION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

