/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricTaskInstanceReport;
import io.openbpm.bpm.engine.history.HistoricTaskInstanceReportResult;
import io.openbpm.bpm.engine.rest.dto.AbstractReportDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;

public class HistoricTaskInstanceReportQueryDto
extends AbstractReportDto<HistoricTaskInstanceReport> {
    public static final String PROCESS_DEFINITION = "processDefinition";
    public static final String TASK_NAME = "taskName";
    protected Date completedBefore;
    protected Date completedAfter;
    protected String groupby;

    public HistoricTaskInstanceReportQueryDto() {
    }

    public HistoricTaskInstanceReportQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    public Date getCompletedBefore() {
        return this.completedBefore;
    }

    public Date getCompletedAfter() {
        return this.completedAfter;
    }

    public String getGroupBy() {
        return this.groupby;
    }

    @OperatonQueryParam(value="completedAfter", converter=DateConverter.class)
    public void setCompletedAfter(Date completedAfter) {
        this.completedAfter = completedAfter;
    }

    @OperatonQueryParam(value="completedBefore", converter=DateConverter.class)
    public void setCompletedBefore(Date completedBefore) {
        this.completedBefore = completedBefore;
    }

    @OperatonQueryParam(value="groupBy")
    public void setGroupBy(String groupby) {
        this.groupby = groupby;
    }

    @Override
    protected void applyFilters(HistoricTaskInstanceReport reportQuery) {
        if (this.completedBefore != null) {
            reportQuery.completedBefore(this.completedBefore);
        }
        if (this.completedAfter != null) {
            reportQuery.completedAfter(this.completedAfter);
        }
        if ("duration".equals(this.reportType) && this.periodUnit == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "periodUnit is null");
        }
    }

    @Override
    protected HistoricTaskInstanceReport createNewReportQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricTaskInstanceReport();
    }

    public List<HistoricTaskInstanceReportResult> executeCompletedReport(ProcessEngine engine) {
        HistoricTaskInstanceReport reportQuery = this.createNewReportQuery(engine);
        this.applyFilters(reportQuery);
        if (PROCESS_DEFINITION.equals(this.groupby)) {
            return reportQuery.countByProcessDefinitionKey();
        }
        if (TASK_NAME.equals(this.groupby)) {
            return reportQuery.countByTaskName();
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "groupBy parameter has invalid value: " + this.groupby);
    }
}

