/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.identity;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.identity.UserQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.StringArrayConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserQueryDto
extends AbstractQueryDto<UserQuery> {
    private static final String SORT_BY_USER_ID_VALUE = "userId";
    private static final String SORT_BY_USER_FIRSTNAME_VALUE = "firstName";
    private static final String SORT_BY_USER_LASTNAME_VALUE = "lastName";
    private static final String SORT_BY_USER_EMAIL_VALUE = "email";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String id;
    protected String[] idIn;
    protected String firstName;
    protected String firstNameLike;
    protected String lastName;
    protected String lastNameLike;
    protected String email;
    protected String emailLike;
    protected String memberOfGroup;
    protected String potentialStarter;
    protected String tenantId;

    public UserQueryDto() {
    }

    public UserQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="id")
    public void setId(String userId) {
        this.id = userId;
    }

    @OperatonQueryParam(value="idIn", converter=StringArrayConverter.class)
    public void setIdIn(String[] ids) {
        this.idIn = ids;
    }

    @OperatonQueryParam(value="firstName")
    public void setFirstName(String userFirstName) {
        this.firstName = userFirstName;
    }

    @OperatonQueryParam(value="firstNameLike")
    public void setFirstNameLike(String userFirstNameLike) {
        this.firstNameLike = userFirstNameLike;
    }

    @OperatonQueryParam(value="lastName")
    public void setLastName(String userLastName) {
        this.lastName = userLastName;
    }

    @OperatonQueryParam(value="lastNameLike")
    public void setLastNameLike(String userLastNameLike) {
        this.lastNameLike = userLastNameLike;
    }

    @OperatonQueryParam(value="email")
    public void setEmail(String userEmail) {
        this.email = userEmail;
    }

    @OperatonQueryParam(value="emailLike")
    public void setEmailLike(String userEmailLike) {
        this.emailLike = userEmailLike;
    }

    @OperatonQueryParam(value="memberOfGroup")
    public void setMemberOfGroup(String memberOfGroup) {
        this.memberOfGroup = memberOfGroup;
    }

    @OperatonQueryParam(value="potentialStarter")
    public void setPotentialStarter(String potentialStarter) {
        this.potentialStarter = potentialStarter;
    }

    @OperatonQueryParam(value="memberOfTenant")
    public void setMemberOfTenant(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected UserQuery createNewQuery(ProcessEngine engine) {
        return engine.getIdentityService().createUserQuery();
    }

    @Override
    protected void applyFilters(UserQuery query) {
        if (this.id != null) {
            query.userId(this.id);
        }
        if (this.idIn != null) {
            query.userIdIn(this.idIn);
        }
        if (this.firstName != null) {
            query.userFirstName(this.firstName);
        }
        if (this.firstNameLike != null) {
            query.userFirstNameLike(this.firstNameLike);
        }
        if (this.lastName != null) {
            query.userLastName(this.lastName);
        }
        if (this.lastNameLike != null) {
            query.userLastNameLike(this.lastNameLike);
        }
        if (this.email != null) {
            query.userEmail(this.email);
        }
        if (this.emailLike != null) {
            query.userEmailLike(this.emailLike);
        }
        if (this.memberOfGroup != null) {
            query.memberOfGroup(this.memberOfGroup);
        }
        if (this.potentialStarter != null) {
            query.potentialStarter(this.potentialStarter);
        }
        if (this.tenantId != null) {
            query.memberOfTenant(this.tenantId);
        }
    }

    @Override
    protected void applySortBy(UserQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_USER_ID_VALUE.equals(sortBy)) {
            query.orderByUserId();
        } else if (SORT_BY_USER_FIRSTNAME_VALUE.equals(sortBy)) {
            query.orderByUserFirstName();
        } else if (SORT_BY_USER_LASTNAME_VALUE.equals(sortBy)) {
            query.orderByUserLastName();
        } else if (SORT_BY_USER_EMAIL_VALUE.equals(sortBy)) {
            query.orderByUserEmail();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_USER_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_USER_FIRSTNAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_USER_LASTNAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_USER_EMAIL_VALUE);
    }
}

