/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.repository.ProcessDefinitionQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.dto.converter.IntegerConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ProcessDefinitionQueryDto
extends AbstractQueryDto<ProcessDefinitionQuery> {
    private static final String SORT_BY_CATEGORY_VALUE = "category";
    private static final String SORT_BY_KEY_VALUE = "key";
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_VERSION_VALUE = "version";
    private static final String SORT_BY_DEPLOYMENT_ID_VALUE = "deploymentId";
    private static final String SORT_BY_DEPLOY_TIME_VALUE = "deployTime";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final String SORT_BY_VERSION_TAG = "versionTag";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String processDefinitionId;
    protected List<String> processDefinitionIdIn;
    protected String category;
    protected String categoryLike;
    protected String name;
    protected String nameLike;
    protected String deploymentId;
    protected Date deployedAfter;
    protected Date deployedAt;
    protected String key;
    protected String keyLike;
    protected Integer version;
    protected Boolean latestVersion;
    protected String resourceName;
    protected String resourceNameLike;
    protected String startableBy;
    protected Boolean active;
    protected Boolean suspended;
    protected String incidentId;
    protected String incidentType;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean includeDefinitionsWithoutTenantId;
    protected String versionTag;
    protected String versionTagLike;
    protected Boolean withoutVersionTag;
    protected List<String> keys;
    protected Boolean startableInTasklist;
    protected Boolean notStartableInTasklist;
    protected Boolean startablePermissionCheck;

    public ProcessDefinitionQueryDto() {
    }

    public ProcessDefinitionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionIdIn", converter=StringListConverter.class)
    public void setProcessDefinitionIdIn(List<String> processDefinitionIdIn) {
        this.processDefinitionIdIn = processDefinitionIdIn;
    }

    @OperatonQueryParam(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @OperatonQueryParam(value="categoryLike")
    public void setCategoryLike(String categoryLike) {
        this.categoryLike = categoryLike;
    }

    @OperatonQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @OperatonQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @OperatonQueryParam(value="deploymentId")
    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @OperatonQueryParam(value="deployedAfter", converter=DateConverter.class)
    public void setDeployedAfter(Date deployedAfter) {
        this.deployedAfter = deployedAfter;
    }

    @OperatonQueryParam(value="deployedAt", converter=DateConverter.class)
    public void setDeployedAt(Date deployedAt) {
        this.deployedAt = deployedAt;
    }

    @OperatonQueryParam(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @OperatonQueryParam(value="keysIn", converter=StringListConverter.class)
    public void setKeysIn(List<String> keys) {
        this.keys = keys;
    }

    @OperatonQueryParam(value="keyLike")
    public void setKeyLike(String keyLike) {
        this.keyLike = keyLike;
    }

    @Deprecated(forRemoval=true, since="1.0")
    @OperatonQueryParam(value="ver", converter=IntegerConverter.class)
    public void setVer(Integer ver) {
        this.setVersion(ver);
    }

    @OperatonQueryParam(value="version", converter=IntegerConverter.class)
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Deprecated(forRemoval=true, since="1.0")
    @OperatonQueryParam(value="latest", converter=BooleanConverter.class)
    public void setLatest(Boolean latest) {
        this.setLatestVersion(latest);
    }

    @OperatonQueryParam(value="latestVersion", converter=BooleanConverter.class)
    public void setLatestVersion(Boolean latestVersion) {
        this.latestVersion = latestVersion;
    }

    @OperatonQueryParam(value="resourceName")
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    @OperatonQueryParam(value="resourceNameLike")
    public void setResourceNameLike(String resourceNameLike) {
        this.resourceNameLike = resourceNameLike;
    }

    @OperatonQueryParam(value="startableBy")
    public void setStartableBy(String startableBy) {
        this.startableBy = startableBy;
    }

    @OperatonQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @OperatonQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @OperatonQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @OperatonQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @OperatonQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @OperatonQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OperatonQueryParam(value="includeProcessDefinitionsWithoutTenantId", converter=BooleanConverter.class)
    public void setIncludeProcessDefinitionsWithoutTenantId(Boolean includeDefinitionsWithoutTenantId) {
        this.includeDefinitionsWithoutTenantId = includeDefinitionsWithoutTenantId;
    }

    @OperatonQueryParam(value="versionTag")
    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }

    @OperatonQueryParam(value="versionTagLike")
    public void setVersionTagLike(String versionTagLike) {
        this.versionTagLike = versionTagLike;
    }

    @OperatonQueryParam(value="withoutVersionTag", converter=BooleanConverter.class)
    public void setWithoutVersionTag(Boolean withoutVersionTag) {
        this.withoutVersionTag = withoutVersionTag;
    }

    @OperatonQueryParam(value="startableInTasklist", converter=BooleanConverter.class)
    public void setStartableInTasklist(Boolean startableInTasklist) {
        this.startableInTasklist = startableInTasklist;
    }

    @OperatonQueryParam(value="notStartableInTasklist", converter=BooleanConverter.class)
    public void setNotStartableInTasklist(Boolean notStartableInTasklist) {
        this.notStartableInTasklist = notStartableInTasklist;
    }

    @OperatonQueryParam(value="startablePermissionCheck", converter=BooleanConverter.class)
    public void setStartablePermissionCheck(Boolean startablePermissionCheck) {
        this.startablePermissionCheck = startablePermissionCheck;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected ProcessDefinitionQuery createNewQuery(ProcessEngine engine) {
        return engine.getRepositoryService().createProcessDefinitionQuery();
    }

    @Override
    protected void applyFilters(ProcessDefinitionQuery query) {
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionIdIn != null && !this.processDefinitionIdIn.isEmpty()) {
            query.processDefinitionIdIn(this.processDefinitionIdIn.toArray(new String[this.processDefinitionIdIn.size()]));
        }
        if (this.category != null) {
            query.processDefinitionCategory(this.category);
        }
        if (this.categoryLike != null) {
            query.processDefinitionCategoryLike(this.categoryLike);
        }
        if (this.name != null) {
            query.processDefinitionName(this.name);
        }
        if (this.nameLike != null) {
            query.processDefinitionNameLike(this.nameLike);
        }
        if (this.deploymentId != null) {
            query.deploymentId(this.deploymentId);
        }
        if (this.deployedAfter != null) {
            query.deployedAfter(this.deployedAfter);
        }
        if (this.deployedAt != null) {
            query.deployedAt(this.deployedAt);
        }
        if (this.key != null) {
            query.processDefinitionKey(this.key);
        }
        if (this.keyLike != null) {
            query.processDefinitionKeyLike(this.keyLike);
        }
        if (this.keys != null && !this.keys.isEmpty()) {
            query.processDefinitionKeysIn(this.keys.toArray(new String[this.keys.size()]));
        }
        if (this.version != null) {
            query.processDefinitionVersion(this.version);
        }
        if (Boolean.TRUE.equals(this.latestVersion)) {
            query.latestVersion();
        }
        if (this.resourceName != null) {
            query.processDefinitionResourceName(this.resourceName);
        }
        if (this.resourceNameLike != null) {
            query.processDefinitionResourceNameLike(this.resourceNameLike);
        }
        if (this.startableBy != null) {
            query.startableByUser(this.startableBy);
        }
        if (Boolean.TRUE.equals(this.active)) {
            query.active();
        }
        if (Boolean.TRUE.equals(this.suspended)) {
            query.suspended();
        }
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.includeDefinitionsWithoutTenantId)) {
            query.includeProcessDefinitionsWithoutTenantId();
        }
        if (this.versionTag != null) {
            query.versionTag(this.versionTag);
        }
        if (this.versionTagLike != null) {
            query.versionTagLike(this.versionTagLike);
        }
        if (Boolean.TRUE.equals(this.withoutVersionTag)) {
            query.withoutVersionTag();
        }
        if (Boolean.TRUE.equals(this.startableInTasklist)) {
            query.startableInTasklist();
        }
        if (Boolean.TRUE.equals(this.notStartableInTasklist)) {
            query.notStartableInTasklist();
        }
        if (Boolean.TRUE.equals(this.startablePermissionCheck)) {
            query.startablePermissionCheck();
        }
    }

    @Override
    protected void applySortBy(ProcessDefinitionQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_CATEGORY_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionCategory();
        } else if (SORT_BY_KEY_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionKey();
        } else if (SORT_BY_ID_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionId();
        } else if (SORT_BY_VERSION_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionVersion();
        } else if (SORT_BY_NAME_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionName();
        } else if (SORT_BY_DEPLOYMENT_ID_VALUE.equals(sortBy)) {
            query.orderByDeploymentId();
        } else if (SORT_BY_DEPLOY_TIME_VALUE.equals(sortBy)) {
            query.orderByDeploymentTime();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        } else if (SORT_BY_VERSION_TAG.equals(sortBy)) {
            query.orderByVersionTag();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_CATEGORY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_VERSION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_VERSION_TAG);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOY_TIME_VALUE);
    }
}

