/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.VariableQueryParameterDto;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.bpm.engine.rest.dto.converter.VariableListConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.runtime.CaseExecutionQuery;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CaseExecutionQueryDto
extends AbstractQueryDto<CaseExecutionQuery> {
    protected static final String SORT_BY_EXECUTION_ID_VALUE = "caseExecutionId";
    protected static final String SORT_BY_DEFINITION_KEY_VALUE = "caseDefinitionKey";
    protected static final String SORT_BY_DEFINITION_ID_VALUE = "caseDefinitionId";
    protected static final String SORT_BY_TENANT_ID = "tenantId";
    protected static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String caseExecutionId;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String businessKey;
    protected String activityId;
    protected List<String> tenantIds;
    protected Boolean required;
    protected Boolean enabled;
    protected Boolean active;
    protected Boolean disabled;
    protected List<VariableQueryParameterDto> variables;
    protected List<VariableQueryParameterDto> caseInstanceVariables;
    protected Boolean variableNamesIgnoreCase;
    protected Boolean variableValuesIgnoreCase;

    public CaseExecutionQueryDto() {
    }

    public CaseExecutionQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="caseExecutionId")
    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @OperatonQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @OperatonQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @OperatonQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @OperatonQueryParam(value="businessKey")
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @OperatonQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="required", converter=BooleanConverter.class)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    @OperatonQueryParam(value="enabled", converter=BooleanConverter.class)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @OperatonQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @OperatonQueryParam(value="disabled", converter=BooleanConverter.class)
    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @OperatonQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    @OperatonQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @OperatonQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    @OperatonQueryParam(value="caseInstanceVariables", converter=VariableListConverter.class)
    public void setCaseInstanceVariables(List<VariableQueryParameterDto> caseInstanceVariables) {
        this.caseInstanceVariables = caseInstanceVariables;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected CaseExecutionQuery createNewQuery(ProcessEngine engine) {
        return engine.getCaseService().createCaseExecutionQuery();
    }

    @Override
    protected void applyFilters(CaseExecutionQuery query) {
        Object variableValue;
        String op;
        String variableName;
        if (this.caseExecutionId != null) {
            query.caseExecutionId(this.caseExecutionId);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.businessKey != null) {
            query.caseInstanceBusinessKey(this.businessKey);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.required)) {
            query.required();
        }
        if (Boolean.TRUE.equals(this.active)) {
            query.active();
        }
        if (Boolean.TRUE.equals(this.enabled)) {
            query.enabled();
        }
        if (Boolean.TRUE.equals(this.disabled)) {
            query.disabled();
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.variables != null) {
            block36: for (VariableQueryParameterDto variableQueryParam : this.variables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                switch (op) {
                    case "eq": {
                        query.variableValueEquals(variableName, variableValue);
                        continue block36;
                    }
                    case "gt": {
                        query.variableValueGreaterThan(variableName, variableValue);
                        continue block36;
                    }
                    case "gteq": {
                        query.variableValueGreaterThanOrEqual(variableName, variableValue);
                        continue block36;
                    }
                    case "lt": {
                        query.variableValueLessThan(variableName, variableValue);
                        continue block36;
                    }
                    case "lteq": {
                        query.variableValueLessThanOrEqual(variableName, variableValue);
                        continue block36;
                    }
                    case "neq": {
                        query.variableValueNotEquals(variableName, variableValue);
                        continue block36;
                    }
                    case "like": {
                        query.variableValueLike(variableName, String.valueOf(variableValue));
                        continue block36;
                    }
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
        if (this.caseInstanceVariables != null) {
            block37: for (VariableQueryParameterDto variableQueryParam : this.caseInstanceVariables) {
                variableName = variableQueryParam.getName();
                op = variableQueryParam.getOperator();
                variableValue = variableQueryParam.resolveValue(this.objectMapper);
                switch (op) {
                    case "eq": {
                        query.caseInstanceVariableValueEquals(variableName, variableValue);
                        continue block37;
                    }
                    case "gt": {
                        query.caseInstanceVariableValueGreaterThan(variableName, variableValue);
                        continue block37;
                    }
                    case "gteq": {
                        query.caseInstanceVariableValueGreaterThanOrEqual(variableName, variableValue);
                        continue block37;
                    }
                    case "lt": {
                        query.caseInstanceVariableValueLessThan(variableName, variableValue);
                        continue block37;
                    }
                    case "lteq": {
                        query.caseInstanceVariableValueLessThanOrEqual(variableName, variableValue);
                        continue block37;
                    }
                    case "neq": {
                        query.caseInstanceVariableValueNotEquals(variableName, variableValue);
                        continue block37;
                    }
                    case "like": {
                        query.caseInstanceVariableValueLike(variableName, String.valueOf(variableValue));
                        continue block37;
                    }
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    @Override
    protected void applySortBy(CaseExecutionQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        switch (sortBy) {
            case "caseExecutionId": {
                query.orderByCaseExecutionId();
                break;
            }
            case "caseDefinitionKey": {
                query.orderByCaseDefinitionKey();
                break;
            }
            case "caseDefinitionId": {
                query.orderByCaseDefinitionId();
                break;
            }
            case "tenantId": {
                query.orderByTenantId();
            }
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

