/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringArrayConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.bpm.engine.runtime.IncidentQuery;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class IncidentQueryDto
extends AbstractQueryDto<IncidentQuery> {
    private static final String SORT_BY_INCIDENT_ID = "incidentId";
    private static final String SORT_BY_INCIDENT_MESSAGE = "incidentMessage";
    private static final String SORT_BY_INCIDENT_TIMESTAMP = "incidentTimestamp";
    private static final String SORT_BY_INCIDENT_TYPE = "incidentType";
    private static final String SORT_BY_EXECUTION_ID = "executionId";
    private static final String SORT_BY_ACTIVITY_ID = "activityId";
    private static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String SORT_BY_CAUSE_INCIDENT_ID = "causeIncidentId";
    private static final String SORT_BY_ROOT_CAUSE_INCIDENT_ID = "rootCauseIncidentId";
    private static final String SORT_BY_CONFIGURATION = "configuration";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String incidentId;
    protected String incidentType;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String processDefinitionId;
    protected String[] processDefinitionKeyIn;
    protected String processInstanceId;
    protected String executionId;
    protected Date incidentTimestampBefore;
    protected Date incidentTimestampAfter;
    protected String activityId;
    protected String failedActivityId;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected List<String> tenantIds;
    protected List<String> jobDefinitionIds;

    public IncidentQueryDto() {
    }

    public IncidentQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="incidentId")
    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @OperatonQueryParam(value="incidentType")
    public void setIncidentType(String incidentType) {
        this.incidentType = incidentType;
    }

    @OperatonQueryParam(value="incidentMessage")
    public void setIncidentMessage(String incidentMessage) {
        this.incidentMessage = incidentMessage;
    }

    @OperatonQueryParam(value="incidentMessageLike")
    public void setIncidentMessageLike(String incidentMessageLike) {
        this.incidentMessageLike = incidentMessageLike;
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionKeyIn(String[] processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    @OperatonQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OperatonQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @OperatonQueryParam(value="incidentTimestampAfter", converter=DateConverter.class)
    public void setIncidentTimestampAfter(Date incidentTimestampAfter) {
        this.incidentTimestampAfter = incidentTimestampAfter;
    }

    @OperatonQueryParam(value="incidentTimestampBefore", converter=DateConverter.class)
    public void setIncidentTimestampBefore(Date incidentTimestampBefore) {
        this.incidentTimestampBefore = incidentTimestampBefore;
    }

    @OperatonQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @OperatonQueryParam(value="failedActivityId")
    public void setFailedActivityId(String activityId) {
        this.failedActivityId = activityId;
    }

    @OperatonQueryParam(value="causeIncidentId")
    public void setCauseIncidentId(String causeIncidentId) {
        this.causeIncidentId = causeIncidentId;
    }

    @OperatonQueryParam(value="rootCauseIncidentId")
    public void setRootCauseIncidentId(String rootCauseIncidentId) {
        this.rootCauseIncidentId = rootCauseIncidentId;
    }

    @OperatonQueryParam(value="configuration")
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="jobDefinitionIdIn", converter=StringListConverter.class)
    public void setJobDefinitionIdIn(List<String> jobDefinitionIds) {
        this.jobDefinitionIds = jobDefinitionIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected IncidentQuery createNewQuery(ProcessEngine engine) {
        return engine.getRuntimeService().createIncidentQuery();
    }

    @Override
    protected void applyFilters(IncidentQuery query) {
        if (this.incidentId != null) {
            query.incidentId(this.incidentId);
        }
        if (this.incidentType != null) {
            query.incidentType(this.incidentType);
        }
        if (this.incidentMessage != null) {
            query.incidentMessage(this.incidentMessage);
        }
        if (this.incidentMessageLike != null) {
            query.incidentMessageLike(this.incidentMessageLike);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKeyIn != null && this.processDefinitionKeyIn.length > 0) {
            query.processDefinitionKeyIn(this.processDefinitionKeyIn);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.incidentTimestampBefore != null) {
            query.incidentTimestampBefore(this.incidentTimestampBefore);
        }
        if (this.incidentTimestampAfter != null) {
            query.incidentTimestampAfter(this.incidentTimestampAfter);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.failedActivityId != null) {
            query.failedActivityId(this.failedActivityId);
        }
        if (this.causeIncidentId != null) {
            query.causeIncidentId(this.causeIncidentId);
        }
        if (this.rootCauseIncidentId != null) {
            query.rootCauseIncidentId(this.rootCauseIncidentId);
        }
        if (this.configuration != null) {
            query.configuration(this.configuration);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (this.jobDefinitionIds != null && !this.jobDefinitionIds.isEmpty()) {
            query.jobDefinitionIdIn(this.jobDefinitionIds.toArray(new String[this.jobDefinitionIds.size()]));
        }
    }

    @Override
    protected void applySortBy(IncidentQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_INCIDENT_ID.equals(sortBy)) {
            query.orderByIncidentId();
        } else if (SORT_BY_INCIDENT_MESSAGE.equals(sortBy)) {
            query.orderByIncidentMessage();
        } else if (SORT_BY_INCIDENT_TIMESTAMP.equals(sortBy)) {
            query.orderByIncidentTimestamp();
        } else if (SORT_BY_INCIDENT_TYPE.equals(sortBy)) {
            query.orderByIncidentType();
        } else if (SORT_BY_EXECUTION_ID.equals(sortBy)) {
            query.orderByExecutionId();
        } else if (SORT_BY_ACTIVITY_ID.equals(sortBy)) {
            query.orderByActivityId();
        } else if (SORT_BY_PROCESS_INSTANCE_ID.equals(sortBy)) {
            query.orderByProcessInstanceId();
        } else if (SORT_BY_PROCESS_DEFINITION_ID.equals(sortBy)) {
            query.orderByProcessDefinitionId();
        } else if (SORT_BY_CAUSE_INCIDENT_ID.equals(sortBy)) {
            query.orderByCauseIncidentId();
        } else if (SORT_BY_ROOT_CAUSE_INCIDENT_ID.equals(sortBy)) {
            query.orderByRootCauseIncidentId();
        } else if (SORT_BY_CONFIGURATION.equals(sortBy)) {
            query.orderByConfiguration();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_MESSAGE);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TIMESTAMP);
        VALID_SORT_BY_VALUES.add(SORT_BY_INCIDENT_TYPE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ACTIVITY_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_ROOT_CAUSE_INCIDENT_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_CONFIGURATION);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

