/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.exception;

import io.openbpm.bpm.engine.AuthorizationException;
import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.ParseException;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.migration.MigratingProcessInstanceValidationException;
import io.openbpm.bpm.engine.migration.MigrationPlanValidationException;
import io.openbpm.bpm.engine.rest.dto.AuthorizationExceptionDto;
import io.openbpm.bpm.engine.rest.dto.ExceptionDto;
import io.openbpm.bpm.engine.rest.dto.ParseExceptionDto;
import io.openbpm.bpm.engine.rest.dto.migration.MigratingProcessInstanceValidationExceptionDto;
import io.openbpm.bpm.engine.rest.dto.migration.MigrationPlanValidationExceptionDto;
import io.openbpm.bpm.engine.rest.exception.ExceptionLogger;
import io.openbpm.bpm.engine.rest.exception.RestException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

public final class ExceptionHandlerHelper {
    protected static final ExceptionLogger LOGGER = ExceptionLogger.REST_LOGGER;
    protected static final ExceptionHandlerHelper INSTANCE = new ExceptionHandlerHelper();

    private ExceptionHandlerHelper() {
    }

    public static ExceptionHandlerHelper getInstance() {
        return INSTANCE;
    }

    public Response getResponse(Throwable throwable) {
        LOGGER.log(throwable);
        Response.Status responseStatus = this.getStatus(throwable);
        ExceptionDto exceptionDto = this.fromException(throwable);
        return Response.status((Response.Status)responseStatus).entity((Object)exceptionDto).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected void provideExceptionCode(Throwable throwable, ExceptionDto exceptionDto) {
        Throwable cause;
        Integer code = null;
        if (throwable instanceof ProcessEngineException) {
            code = this.getCode(throwable);
        } else if (throwable instanceof RestException && (cause = throwable.getCause()) instanceof ProcessEngineException) {
            code = this.getCode(cause);
        }
        if (code != null) {
            exceptionDto.setCode(code);
        }
    }

    protected Integer getCode(Throwable throwable) {
        ProcessEngineException pex = (ProcessEngineException)throwable;
        return pex.getCode();
    }

    public ExceptionDto fromException(Throwable e) {
        ExceptionDto exceptionDto;
        if (e instanceof MigratingProcessInstanceValidationException) {
            MigratingProcessInstanceValidationException exception = (MigratingProcessInstanceValidationException)e;
            exceptionDto = MigratingProcessInstanceValidationExceptionDto.from(exception);
        } else if (e instanceof MigrationPlanValidationException) {
            MigrationPlanValidationException exception = (MigrationPlanValidationException)e;
            exceptionDto = MigrationPlanValidationExceptionDto.from(exception);
        } else if (e instanceof AuthorizationException) {
            AuthorizationException exception = (AuthorizationException)e;
            exceptionDto = AuthorizationExceptionDto.fromException(exception);
        } else if (e instanceof ParseException) {
            ParseException exception = (ParseException)e;
            exceptionDto = ParseExceptionDto.fromException(exception);
        } else {
            exceptionDto = ExceptionDto.fromException(e);
        }
        this.provideExceptionCode(e, exceptionDto);
        return exceptionDto;
    }

    public Response.Status getStatus(Throwable exception) {
        Response.Status responseStatus = Response.Status.INTERNAL_SERVER_ERROR;
        if (exception instanceof ProcessEngineException) {
            ProcessEngineException engineException = (ProcessEngineException)exception;
            responseStatus = this.getStatus(engineException);
        } else if (exception instanceof RestException) {
            RestException restException = (RestException)exception;
            responseStatus = this.getStatus(restException);
        } else if (exception instanceof WebApplicationException) {
            WebApplicationException applicationException = (WebApplicationException)exception;
            int statusCode = applicationException.getResponse().getStatus();
            responseStatus = Response.Status.fromStatusCode((int)statusCode);
        }
        return responseStatus;
    }

    public Response.Status getStatus(ProcessEngineException exception) {
        Response.Status responseStatus = Response.Status.INTERNAL_SERVER_ERROR;
        if (exception instanceof AuthorizationException) {
            responseStatus = Response.Status.FORBIDDEN;
        } else if (exception instanceof MigrationPlanValidationException || exception instanceof MigratingProcessInstanceValidationException || exception instanceof BadUserRequestException || exception instanceof ParseException) {
            responseStatus = Response.Status.BAD_REQUEST;
        }
        return responseStatus;
    }

    public Response.Status getStatus(RestException exception) {
        if (exception.getStatus() != null) {
            return exception.getStatus();
        }
        return Response.Status.INTERNAL_SERVER_ERROR;
    }
}

