/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ManagementService;
import io.openbpm.bpm.engine.rest.TelemetryRestService;
import io.openbpm.bpm.engine.rest.dto.TelemetryConfigurationDto;
import io.openbpm.bpm.engine.rest.dto.telemetry.TelemetryDataDto;
import io.openbpm.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.openbpm.bpm.engine.telemetry.TelemetryData;

public class TelemetryRestServiceImpl
extends AbstractRestProcessEngineAware
implements TelemetryRestService {
    public TelemetryRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public void configureTelemetry(TelemetryConfigurationDto dto) {
        boolean enableTelemetry = dto.isEnableTelemetry();
        ManagementService managementService = this.getProcessEngine().getManagementService();
        managementService.toggleTelemetry(enableTelemetry);
    }

    @Override
    public TelemetryConfigurationDto getTelemetryConfiguration() {
        ManagementService managementService = this.getProcessEngine().getManagementService();
        Boolean telemetryEnabled = managementService.isTelemetryEnabled();
        return new TelemetryConfigurationDto(telemetryEnabled);
    }

    @Override
    public TelemetryDataDto getTelemetryData() {
        ManagementService managementService = this.getProcessEngine().getManagementService();
        TelemetryData data = managementService.getTelemetryData();
        return TelemetryDataDto.fromEngineDto(data);
    }
}

