/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.CleanableHistoricProcessInstanceReport;
import io.openbpm.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import io.openbpm.bpm.engine.history.HistoricActivityStatistics;
import io.openbpm.bpm.engine.history.HistoricActivityStatisticsQuery;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import io.openbpm.bpm.engine.rest.dto.history.CleanableHistoricProcessInstanceReportDto;
import io.openbpm.bpm.engine.rest.dto.history.CleanableHistoricProcessInstanceReportResultDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricActivityStatisticsDto;
import io.openbpm.bpm.engine.rest.history.HistoricProcessDefinitionRestService;
import io.openbpm.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import io.openbpm.bpm.engine.rest.impl.history.HistoricActivityStatisticsQueryDto;
import io.openbpm.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class HistoricProcessDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements HistoricProcessDefinitionRestService {
    public HistoricProcessDefinitionRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        super(processEngine.getName(), objectMapper);
    }

    @Override
    public List<HistoricActivityStatisticsDto> getHistoricActivityStatistics(UriInfo uriInfo, String processDefinitionId) {
        HistoricActivityStatisticsQueryDto queryDto = new HistoricActivityStatisticsQueryDto(this.getObjectMapper(), processDefinitionId, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)queryDto.toQuery(this.getProcessEngine());
        ArrayList<HistoricActivityStatisticsDto> result = new ArrayList<HistoricActivityStatisticsDto>();
        List statistics = query.unlimitedList();
        for (HistoricActivityStatistics currentStatistics : statistics) {
            result.add(HistoricActivityStatisticsDto.fromHistoricActivityStatistics(currentStatistics));
        }
        return result;
    }

    @Override
    public List<CleanableHistoricProcessInstanceReportResultDto> getCleanableHistoricProcessInstanceReport(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CleanableHistoricProcessInstanceReportDto queryDto = new CleanableHistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        CleanableHistoricProcessInstanceReport query = (CleanableHistoricProcessInstanceReport)queryDto.toQuery(this.getProcessEngine());
        List<CleanableHistoricProcessInstanceReportResult> reportResult = QueryUtil.list(query, firstResult, maxResults);
        return CleanableHistoricProcessInstanceReportResultDto.convert(reportResult);
    }

    @Override
    public CountResultDto getCleanableHistoricProcessInstanceReportCount(UriInfo uriInfo) {
        CleanableHistoricProcessInstanceReportDto queryDto = new CleanableHistoricProcessInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.setObjectMapper(this.objectMapper);
        CleanableHistoricProcessInstanceReport query = (CleanableHistoricProcessInstanceReport)queryDto.toQuery(this.getProcessEngine());
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

