/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.batch.impl;

import io.openbpm.bpm.engine.BadUserRequestException;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.batch.Batch;
import io.openbpm.bpm.engine.rest.dto.SuspensionStateDto;
import io.openbpm.bpm.engine.rest.dto.batch.BatchDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.sub.batch.BatchResource;
import jakarta.ws.rs.core.Response;

public class BatchResourceImpl
implements BatchResource {
    protected ProcessEngine processEngine;
    protected String batchId;

    public BatchResourceImpl(ProcessEngine processEngine, String batchId) {
        this.processEngine = processEngine;
        this.batchId = batchId;
    }

    @Override
    public BatchDto getBatch() {
        Batch batch = (Batch)this.processEngine.getManagementService().createBatchQuery().batchId(this.batchId).singleResult();
        if (batch == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Batch with id '" + this.batchId + "' does not exist");
        }
        return BatchDto.fromBatch(batch);
    }

    @Override
    public void updateSuspensionState(SuspensionStateDto suspensionState) {
        if (suspensionState.getSuspended()) {
            this.suspendBatch();
        } else {
            this.activateBatch();
        }
    }

    protected void suspendBatch() {
        try {
            this.processEngine.getManagementService().suspendBatchById(this.batchId);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Unable to suspend batch with id '" + this.batchId + "'");
        }
    }

    protected void activateBatch() {
        try {
            this.processEngine.getManagementService().activateBatchById(this.batchId);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Unable to activate batch with id '" + this.batchId + "'");
        }
    }

    @Override
    public void deleteBatch(boolean cascade) {
        try {
            this.processEngine.getManagementService().deleteBatch(this.batchId, cascade);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Unable to delete batch with id '" + this.batchId + "'");
        }
    }
}

