/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.history.impl;

import io.openbpm.bpm.engine.HistoryService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricCaseInstance;
import io.openbpm.bpm.engine.rest.dto.history.HistoricCaseInstanceDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.sub.history.HistoricCaseInstanceResource;
import jakarta.ws.rs.core.Response;

public class HistoricCaseInstanceResourceImpl
implements HistoricCaseInstanceResource {
    private final ProcessEngine engine;
    private final String caseInstanceId;

    public HistoricCaseInstanceResourceImpl(ProcessEngine engine, String caseInstanceId) {
        this.engine = engine;
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public HistoricCaseInstanceDto getHistoricCaseInstance() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricCaseInstance instance = (HistoricCaseInstance)historyService.createHistoricCaseInstanceQuery().caseInstanceId(this.caseInstanceId).singleResult();
        if (instance == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic case instance with id '" + this.caseInstanceId + "' does not exist");
        }
        return HistoricCaseInstanceDto.fromHistoricCaseInstance(instance);
    }
}

