/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.history.impl;

import io.openbpm.bpm.engine.HistoryService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricDecisionInstance;
import io.openbpm.bpm.engine.history.HistoricDecisionInstanceQuery;
import io.openbpm.bpm.engine.rest.dto.history.HistoricDecisionInstanceDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.sub.history.HistoricDecisionInstanceResource;
import jakarta.ws.rs.core.Response;

public class HistoricDecisionInstanceResourceImpl
implements HistoricDecisionInstanceResource {
    private final ProcessEngine engine;
    private final String decisionInstanceId;

    public HistoricDecisionInstanceResourceImpl(ProcessEngine engine, String decisionInstanceId) {
        this.engine = engine;
        this.decisionInstanceId = decisionInstanceId;
    }

    @Override
    public HistoricDecisionInstanceDto getHistoricDecisionInstance(Boolean includeInputs, Boolean includeOutputs, Boolean disableBinaryFetching, Boolean disableCustomObjectDeserialization) {
        HistoricDecisionInstance instance;
        HistoryService historyService = this.engine.getHistoryService();
        HistoricDecisionInstanceQuery query = historyService.createHistoricDecisionInstanceQuery().decisionInstanceId(this.decisionInstanceId);
        if (includeInputs != null && includeInputs.booleanValue()) {
            query.includeInputs();
        }
        if (includeOutputs != null && includeOutputs.booleanValue()) {
            query.includeOutputs();
        }
        if (disableBinaryFetching != null && disableBinaryFetching.booleanValue()) {
            query.disableBinaryFetching();
        }
        if (disableCustomObjectDeserialization != null && disableCustomObjectDeserialization.booleanValue()) {
            query.disableCustomObjectDeserialization();
        }
        if ((instance = (HistoricDecisionInstance)query.singleResult()) == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic decision instance with id '" + this.decisionInstanceId + "' does not exist");
        }
        return HistoricDecisionInstanceDto.fromHistoricDecisionInstance(instance);
    }
}

