/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.history.impl;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricDetail;
import io.openbpm.bpm.engine.history.HistoricDetailQuery;
import io.openbpm.bpm.engine.history.HistoricVariableUpdate;
import io.openbpm.bpm.engine.query.Query;
import io.openbpm.bpm.engine.rest.dto.history.HistoricDetailDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.sub.AbstractResourceProvider;
import io.openbpm.bpm.engine.rest.sub.history.HistoricDetailResource;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import jakarta.ws.rs.core.Response;

public class HistoricDetailResourceImpl
extends AbstractResourceProvider<HistoricDetailQuery, HistoricDetail, HistoricDetailDto>
implements HistoricDetailResource {
    public HistoricDetailResourceImpl(String detailId, ProcessEngine engine) {
        super(detailId, engine);
    }

    protected HistoricDetailQuery baseQuery() {
        return this.engine.getHistoryService().createHistoricDetailQuery().detailId(this.getId());
    }

    @Override
    protected Query<HistoricDetailQuery, HistoricDetail> baseQueryForBinaryVariable() {
        return this.baseQuery().disableCustomObjectDeserialization();
    }

    @Override
    protected Query<HistoricDetailQuery, HistoricDetail> baseQueryForVariable(boolean deserializeObjectValue) {
        HistoricDetailQuery query = this.baseQuery().disableBinaryFetching();
        if (!deserializeObjectValue) {
            query.disableCustomObjectDeserialization();
        }
        return query;
    }

    @Override
    protected TypedValue transformQueryResultIntoTypedValue(HistoricDetail queryResult) {
        if (!(queryResult instanceof HistoricVariableUpdate)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Historic detail with Id '" + this.getId() + "' is not a variable update.");
        }
        HistoricVariableUpdate update = (HistoricVariableUpdate)queryResult;
        return update.getTypedValue();
    }

    @Override
    protected HistoricDetailDto transformToDto(HistoricDetail queryResult) {
        return HistoricDetailDto.fromHistoricDetail(queryResult);
    }

    @Override
    protected String getResourceNameForErrorMessage() {
        return "Historic detail";
    }
}

