/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.history.impl;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.history.HistoricVariableInstance;
import io.openbpm.bpm.engine.history.HistoricVariableInstanceQuery;
import io.openbpm.bpm.engine.query.Query;
import io.openbpm.bpm.engine.rest.dto.history.HistoricVariableInstanceDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.sub.AbstractResourceProvider;
import io.openbpm.bpm.engine.rest.sub.history.HistoricVariableInstanceResource;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import jakarta.ws.rs.core.Response;

public class HistoricVariableInstanceResourceImpl
extends AbstractResourceProvider<HistoricVariableInstanceQuery, HistoricVariableInstance, HistoricVariableInstanceDto>
implements HistoricVariableInstanceResource {
    public HistoricVariableInstanceResourceImpl(String variableId, ProcessEngine engine) {
        super(variableId, engine);
    }

    protected HistoricVariableInstanceQuery baseQuery() {
        return this.getEngine().getHistoryService().createHistoricVariableInstanceQuery().variableId(this.getId());
    }

    @Override
    protected Query<HistoricVariableInstanceQuery, HistoricVariableInstance> baseQueryForBinaryVariable() {
        return this.baseQuery().disableCustomObjectDeserialization();
    }

    @Override
    protected Query<HistoricVariableInstanceQuery, HistoricVariableInstance> baseQueryForVariable(boolean deserializeObjectValue) {
        HistoricVariableInstanceQuery query = this.baseQuery().disableBinaryFetching();
        if (!deserializeObjectValue) {
            query.disableCustomObjectDeserialization();
        }
        return query;
    }

    @Override
    protected TypedValue transformQueryResultIntoTypedValue(HistoricVariableInstance queryResult) {
        return queryResult.getTypedValue();
    }

    @Override
    protected HistoricVariableInstanceDto transformToDto(HistoricVariableInstance queryResult) {
        return HistoricVariableInstanceDto.fromHistoricVariableInstance(queryResult);
    }

    @Override
    protected String getResourceNameForErrorMessage() {
        return "Historic variable instance";
    }

    @Override
    public Response deleteVariableInstance() {
        try {
            this.getEngine().getHistoryService().deleteHistoricVariableInstance(this.id);
        }
        catch (NotFoundException nfe) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)nfe), nfe.getMessage());
        }
        return Response.noContent().build();
    }
}

