/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.CaseService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.exception.NotAllowedException;
import io.openbpm.bpm.engine.exception.NotFoundException;
import io.openbpm.bpm.engine.exception.NotValidException;
import io.openbpm.bpm.engine.rest.dto.runtime.CaseExecutionDto;
import io.openbpm.bpm.engine.rest.dto.runtime.CaseExecutionTriggerDto;
import io.openbpm.bpm.engine.rest.dto.runtime.TriggerVariableValueDto;
import io.openbpm.bpm.engine.rest.dto.runtime.VariableNameDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.exception.RestException;
import io.openbpm.bpm.engine.rest.sub.VariableResource;
import io.openbpm.bpm.engine.rest.sub.runtime.CaseExecutionResource;
import io.openbpm.bpm.engine.rest.sub.runtime.impl.CaseExecutionVariablesResource;
import io.openbpm.bpm.engine.rest.sub.runtime.impl.LocalCaseExecutionVariablesResource;
import io.openbpm.bpm.engine.runtime.CaseExecution;
import io.openbpm.bpm.engine.runtime.CaseExecutionCommandBuilder;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;

public class CaseExecutionResourceImpl
implements CaseExecutionResource {
    private static final String TRANSITION_MANUAL_START = "manualStart";
    private static final String TRANSITION_REENABLE = "reenable";
    private static final String TRANSITION_COMPLETE = "complete";
    private static final String TRANSITION_TERMINATE = "terminate";
    private static final String TRANSITION_DISABLE = "disable";
    protected ProcessEngine engine;
    protected String caseExecutionId;
    protected ObjectMapper objectMapper;

    public CaseExecutionResourceImpl(ProcessEngine engine, String caseExecutionId, ObjectMapper objectMapper) {
        this.engine = engine;
        this.caseExecutionId = caseExecutionId;
        this.objectMapper = objectMapper;
    }

    @Override
    public CaseExecutionDto getCaseExecution() {
        CaseService caseService = this.engine.getCaseService();
        CaseExecution execution = (CaseExecution)caseService.createCaseExecutionQuery().caseExecutionId(this.caseExecutionId).singleResult();
        if (execution == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Case execution with id " + this.caseExecutionId + " does not exist.");
        }
        return CaseExecutionDto.fromCaseExecution(execution);
    }

    @Override
    public void manualStart(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, "start manually");
            commandBuilder.manualStart();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException(TRANSITION_MANUAL_START, Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException(TRANSITION_MANUAL_START, Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException(TRANSITION_MANUAL_START, Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException(TRANSITION_MANUAL_START, Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void disable(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, TRANSITION_DISABLE);
            commandBuilder.disable();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException(TRANSITION_DISABLE, Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException(TRANSITION_DISABLE, Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException(TRANSITION_DISABLE, Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException(TRANSITION_DISABLE, Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void reenable(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, TRANSITION_REENABLE);
            commandBuilder.reenable();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException(TRANSITION_REENABLE, Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException(TRANSITION_REENABLE, Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException(TRANSITION_REENABLE, Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException(TRANSITION_REENABLE, Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void complete(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, TRANSITION_COMPLETE);
            commandBuilder.complete();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException(TRANSITION_COMPLETE, Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException(TRANSITION_COMPLETE, Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException(TRANSITION_COMPLETE, Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException(TRANSITION_COMPLETE, Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    @Override
    public void terminate(CaseExecutionTriggerDto triggerDto) {
        try {
            CaseService caseService = this.engine.getCaseService();
            CaseExecutionCommandBuilder commandBuilder = caseService.withCaseExecution(this.caseExecutionId);
            this.initializeCommand(commandBuilder, triggerDto, TRANSITION_TERMINATE);
            commandBuilder.terminate();
        }
        catch (NotFoundException e) {
            throw this.createInvalidRequestException(TRANSITION_TERMINATE, Response.Status.NOT_FOUND, (ProcessEngineException)((Object)e));
        }
        catch (NotValidException e) {
            throw this.createInvalidRequestException(TRANSITION_TERMINATE, Response.Status.BAD_REQUEST, (ProcessEngineException)((Object)e));
        }
        catch (NotAllowedException e) {
            throw this.createInvalidRequestException(TRANSITION_TERMINATE, Response.Status.FORBIDDEN, (ProcessEngineException)((Object)e));
        }
        catch (ProcessEngineException e) {
            throw this.createRestException(TRANSITION_TERMINATE, Response.Status.INTERNAL_SERVER_ERROR, e);
        }
    }

    protected InvalidRequestException createInvalidRequestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = "Cannot %s case execution %s: %s".formatted(transition, this.caseExecutionId, cause.getMessage());
        return new InvalidRequestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected RestException createRestException(String transition, Response.Status status, ProcessEngineException cause) {
        String errorMessage = "Cannot %s case execution %s: %s".formatted(transition, this.caseExecutionId, cause.getMessage());
        return new RestException(status, (Exception)((Object)cause), errorMessage);
    }

    protected void initializeCommand(CaseExecutionCommandBuilder commandBuilder, CaseExecutionTriggerDto triggerDto, String transition) {
        List<VariableNameDto> deletions;
        Map<String, TriggerVariableValueDto> variables = triggerDto.getVariables();
        if (variables != null && !variables.isEmpty()) {
            this.initializeCommandWithVariables(commandBuilder, variables, transition);
        }
        if ((deletions = triggerDto.getDeletions()) != null && !deletions.isEmpty()) {
            this.initializeCommandWithDeletions(commandBuilder, deletions, transition);
        }
    }

    protected void initializeCommandWithVariables(CaseExecutionCommandBuilder commandBuilder, Map<String, TriggerVariableValueDto> variables, String transition) {
        for (Map.Entry<String, TriggerVariableValueDto> vars : variables.entrySet()) {
            String variableName = vars.getKey();
            try {
                TriggerVariableValueDto variableValue = vars.getValue();
                TypedValue typedValue = variableValue.toTypedValue(this.engine, this.objectMapper);
                if (variableValue.isLocal()) {
                    commandBuilder.setVariableLocal(variableName, (Object)typedValue);
                    continue;
                }
                commandBuilder.setVariable(variableName, (Object)typedValue);
            }
            catch (RestException e) {
                String errorMessage = "Cannot %s case execution %s due to invalid variable %s: %s".formatted(transition, this.caseExecutionId, variableName, e.getMessage());
                throw new RestException(e.getStatus(), e, errorMessage);
            }
        }
    }

    protected void initializeCommandWithDeletions(CaseExecutionCommandBuilder commandBuilder, List<VariableNameDto> deletions, String transition) {
        for (VariableNameDto variableName : deletions) {
            if (variableName.isLocal()) {
                commandBuilder.removeVariableLocal(variableName.getName());
                continue;
            }
            commandBuilder.removeVariable(variableName.getName());
        }
    }

    @Override
    public VariableResource getVariablesLocal() {
        return new LocalCaseExecutionVariablesResource(this.engine, this.caseExecutionId, this.objectMapper);
    }

    @Override
    public VariableResource getVariables() {
        return new CaseExecutionVariablesResource(this.engine, this.caseExecutionId, this.objectMapper);
    }
}

