/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.runtime.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.impl.RuntimeServiceImpl;
import io.openbpm.bpm.engine.rest.sub.impl.AbstractVariablesResource;
import io.openbpm.bpm.engine.variable.VariableMap;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import java.util.List;
import java.util.Map;

public class LocalExecutionVariablesResource
extends AbstractVariablesResource {
    public LocalExecutionVariablesResource(ProcessEngine engine, String resourceId, ObjectMapper objectMapper) {
        super(engine, resourceId, objectMapper);
    }

    @Override
    protected String getResourceTypeName() {
        return "execution";
    }

    @Override
    protected void updateVariableEntities(VariableMap modifications, List<String> deletions) {
        RuntimeServiceImpl runtimeService = (RuntimeServiceImpl)this.engine.getRuntimeService();
        runtimeService.updateVariablesLocal(this.resourceId, (Map)modifications, deletions);
    }

    @Override
    protected void removeVariableEntity(String variableKey) {
        this.engine.getRuntimeService().removeVariableLocal(this.resourceId, variableKey);
    }

    @Override
    protected VariableMap getVariableEntities(boolean deserializeValues) {
        return this.engine.getRuntimeService().getVariablesLocalTyped(this.resourceId, deserializeValues);
    }

    @Override
    protected TypedValue getVariableEntity(String variableKey, boolean deserializeValue) {
        return this.engine.getRuntimeService().getVariableLocalTyped(this.resourceId, variableKey, deserializeValue);
    }

    @Override
    protected void setVariableEntity(String variableKey, TypedValue variableValue) {
        this.engine.getRuntimeService().setVariableLocal(this.resourceId, variableKey, (Object)variableValue);
    }
}

