/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.task.impl;

import io.openbpm.bpm.engine.IdentityService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.history.HistoricTaskInstance;
import io.openbpm.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import io.openbpm.bpm.engine.impl.identity.Authentication;
import io.openbpm.bpm.engine.rest.dto.task.AttachmentDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.mapper.MultipartFormData;
import io.openbpm.bpm.engine.rest.sub.task.TaskAttachmentResource;
import io.openbpm.bpm.engine.task.Attachment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TaskAttachmentResourceImpl
implements TaskAttachmentResource {
    private final ProcessEngine engine;
    private final String taskId;
    private final String rootResourcePath;

    public TaskAttachmentResourceImpl(ProcessEngine engine, String taskId, String rootResourcePath) {
        this.engine = engine;
        this.taskId = taskId;
        this.rootResourcePath = rootResourcePath;
    }

    @Override
    public List<AttachmentDto> getAttachments() {
        if (!this.isHistoryEnabled()) {
            return Collections.emptyList();
        }
        this.ensureTaskExists(Response.Status.NOT_FOUND);
        List taskAttachments = this.engine.getTaskService().getTaskAttachments(this.taskId);
        ArrayList<AttachmentDto> attachments = new ArrayList<AttachmentDto>();
        for (Attachment attachment : taskAttachments) {
            attachments.add(AttachmentDto.fromAttachment(attachment));
        }
        return attachments;
    }

    @Override
    public AttachmentDto getAttachment(String attachmentId) {
        this.ensureHistoryEnabled(Response.Status.NOT_FOUND);
        Attachment attachment = this.engine.getTaskService().getTaskAttachment(this.taskId, attachmentId);
        if (attachment == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Task attachment with id " + attachmentId + " does not exist for task id '" + this.taskId + "'.");
        }
        return AttachmentDto.fromAttachment(attachment);
    }

    @Override
    public InputStream getAttachmentData(String attachmentId) {
        this.ensureHistoryEnabled(Response.Status.NOT_FOUND);
        InputStream attachmentData = this.engine.getTaskService().getTaskAttachmentContent(this.taskId, attachmentId);
        if (attachmentData != null) {
            return attachmentData;
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Attachment content for attachment with id '" + attachmentId + "' does not exist for task id '" + this.taskId + "'.");
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        try {
            this.engine.getTaskService().deleteTaskAttachment(this.taskId, attachmentId);
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deletion is not possible. No attachment exists for task id '" + this.taskId + "' and attachment id '" + attachmentId + "'.");
        }
    }

    @Override
    public AttachmentDto addAttachment(UriInfo uriInfo, MultipartFormData payload) {
        this.ensureHistoryEnabled(Response.Status.FORBIDDEN);
        this.ensureTaskExists(Response.Status.BAD_REQUEST);
        MultipartFormData.FormPart attachmentNamePart = payload.getNamedPart("attachment-name");
        MultipartFormData.FormPart attachmentTypePart = payload.getNamedPart("attachment-type");
        MultipartFormData.FormPart attachmentDescriptionPart = payload.getNamedPart("attachment-description");
        MultipartFormData.FormPart contentPart = payload.getNamedPart("content");
        MultipartFormData.FormPart urlPart = payload.getNamedPart("url");
        if (urlPart == null && contentPart == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No content or url to remote content exists to create the task attachment.");
        }
        String attachmentName = null;
        String attachmentDescription = null;
        String attachmentType = null;
        if (attachmentNamePart != null) {
            attachmentName = attachmentNamePart.getTextContent();
        }
        if (attachmentDescriptionPart != null) {
            attachmentDescription = attachmentDescriptionPart.getTextContent();
        }
        if (attachmentTypePart != null) {
            attachmentType = attachmentTypePart.getTextContent();
        }
        Attachment attachment = null;
        try {
            if (contentPart != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contentPart.getBinaryContent());
                attachment = this.engine.getTaskService().createAttachment(attachmentType, this.taskId, null, attachmentName, attachmentDescription, (InputStream)byteArrayInputStream);
            } else if (urlPart != null) {
                attachment = this.engine.getTaskService().createAttachment(attachmentType, this.taskId, null, attachmentName, attachmentDescription, urlPart.getTextContent());
            }
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Task id is null");
        }
        URI uri = uriInfo.getBaseUriBuilder().path(this.rootResourcePath).path("/task").path(this.taskId + "/attachment/" + attachment.getId()).build(new Object[0]);
        AttachmentDto attachmentDto = AttachmentDto.fromAttachment(attachment);
        attachmentDto.addReflexiveLink(uri, "GET", "self");
        return attachmentDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHistoryEnabled() {
        IdentityService identityService = this.engine.getIdentityService();
        Authentication currentAuthentication = identityService.getCurrentAuthentication();
        try {
            identityService.clearAuthentication();
            int historyLevel = this.engine.getManagementService().getHistoryLevel();
            boolean bl = historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE;
            return bl;
        }
        finally {
            identityService.setAuthentication(currentAuthentication);
        }
    }

    private void ensureHistoryEnabled(Response.Status status) {
        if (!this.isHistoryEnabled()) {
            throw new InvalidRequestException(status, "History is not enabled");
        }
    }

    private void ensureTaskExists(Response.Status status) {
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.engine.getHistoryService().createHistoricTaskInstanceQuery().taskId(this.taskId).singleResult();
        if (historicTaskInstance == null) {
            throw new InvalidRequestException(status, "No task found for task id " + this.taskId);
        }
    }
}

