/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.util;

import io.openbpm.bpm.engine.query.Query;
import java.util.List;

public final class QueryUtil {
    private QueryUtil() {
    }

    public static <T extends Query<?, ?>, U> List<U> list(Query<T, U> query, Integer firstResult, Integer maxResults) {
        List<U> results = firstResult != null || maxResults != null ? QueryUtil.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        return results;
    }

    private static <T extends Query<?, ?>, U> List<U> executePaginatedQuery(Query<T, U> query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }
}

