/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.converter;

import io.openbpm.bpm.engine.rest.dto.VariableQueryParameterDto;
import io.openbpm.bpm.engine.rest.dto.converter.JacksonAwareStringToTypeConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

public class VariableListConverter
extends JacksonAwareStringToTypeConverter<List<VariableQueryParameterDto>> {
    private static final String EXPRESSION_DELIMITER = ",";
    private static final String ATTRIBUTE_DELIMITER = "_";

    @Override
    public List<VariableQueryParameterDto> convertQueryParameterToType(String value) {
        String[] expressions = value.split(EXPRESSION_DELIMITER);
        ArrayList<VariableQueryParameterDto> queryVariables = new ArrayList<VariableQueryParameterDto>();
        for (String expression : expressions) {
            String[] valueTriple = expression.split(ATTRIBUTE_DELIMITER);
            if (valueTriple.length != 3) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "variable query parameter has to have format KEY_OPERATOR_VALUE.");
            }
            VariableQueryParameterDto queryVariable = new VariableQueryParameterDto();
            queryVariable.setName(valueTriple[0]);
            queryVariable.setOperator(valueTriple[1]);
            queryVariable.setValue(valueTriple[2]);
            queryVariables.add(queryVariable);
        }
        return queryVariables;
    }
}

