/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.identity;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.identity.TenantQuery;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TenantQueryDto
extends AbstractQueryDto<TenantQuery> {
    private static final String SORT_BY_TENANT_ID_VALUE = "id";
    private static final String SORT_BY_TENANT_NAME_VALUE = "name";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String id;
    protected String name;
    protected String nameLike;
    protected String userId;
    protected String groupId;
    protected Boolean includingGroupsOfUser;

    public TenantQueryDto() {
    }

    public TenantQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @OperatonQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @OperatonQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @OperatonQueryParam(value="userMember")
    public void setUserMember(String userId) {
        this.userId = userId;
    }

    @OperatonQueryParam(value="groupMember")
    public void setGroupMember(String groupId) {
        this.groupId = groupId;
    }

    @OperatonQueryParam(value="includingGroupsOfUser", converter=BooleanConverter.class)
    public void setIncludingGroupsOfUser(Boolean includingGroupsOfUser) {
        this.includingGroupsOfUser = includingGroupsOfUser;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected TenantQuery createNewQuery(ProcessEngine engine) {
        return engine.getIdentityService().createTenantQuery();
    }

    @Override
    protected void applyFilters(TenantQuery query) {
        if (this.id != null) {
            query.tenantId(this.id);
        }
        if (this.name != null) {
            query.tenantName(this.name);
        }
        if (this.nameLike != null) {
            query.tenantNameLike(this.nameLike);
        }
        if (this.userId != null) {
            query.userMember(this.userId);
        }
        if (this.groupId != null) {
            query.groupMember(this.groupId);
        }
        if (Boolean.TRUE.equals(this.includingGroupsOfUser)) {
            query.includingGroupsOfUser(true);
        }
    }

    @Override
    protected void applySortBy(TenantQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_TENANT_ID_VALUE.equals(sortBy)) {
            query.orderByTenantId();
        } else if (SORT_BY_TENANT_NAME_VALUE.equals(sortBy)) {
            query.orderByTenantName();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_NAME_VALUE);
    }
}

