/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.dto.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.rest.dto.AbstractQueryDto;
import io.openbpm.bpm.engine.rest.dto.ConditionQueryParameterDto;
import io.openbpm.bpm.engine.rest.dto.OperatonQueryParam;
import io.openbpm.bpm.engine.rest.dto.converter.BooleanConverter;
import io.openbpm.bpm.engine.rest.dto.converter.ConditionListConverter;
import io.openbpm.bpm.engine.rest.dto.converter.DateConverter;
import io.openbpm.bpm.engine.rest.dto.converter.LongConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringListConverter;
import io.openbpm.bpm.engine.rest.dto.converter.StringSetConverter;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.exception.RestException;
import io.openbpm.bpm.engine.runtime.JobQuery;
import io.openbpm.commons.utils.CollectionUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JobQueryDto
extends AbstractQueryDto<JobQuery> {
    private static final String SORT_BY_JOB_ID_VALUE = "jobId";
    private static final String SORT_BY_EXECUTION_ID_VALUE = "executionId";
    private static final String SORT_BY_PROCESS_INSTANCE_ID_VALUE = "processInstanceId";
    private static final String SORT_BY_PROCESS_DEFINITION_ID_VALUE = "processDefinitionId";
    private static final String SORT_BY_PROCESS_DEFINITION_KEY_VALUE = "processDefinitionKey";
    private static final String SORT_BY_JOB_RETRIES_VALUE = "jobRetries";
    private static final String SORT_BY_JOB_DUEDATE_VALUE = "jobDueDate";
    private static final String SORT_BY_JOB_PRIORITY_VALUE = "jobPriority";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String activityId;
    protected String jobId;
    protected Set<String> jobIds;
    protected String executionId;
    protected String processInstanceId;
    protected Set<String> processInstanceIds;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected Boolean withRetriesLeft;
    protected Boolean executable;
    protected Boolean timers;
    protected Boolean messages;
    protected Boolean withException;
    protected String exceptionMessage;
    protected String failedActivityId;
    protected Boolean noRetriesLeft;
    protected Boolean active;
    protected Boolean suspended;
    protected Long priorityHigherThanOrEquals;
    protected Long priorityLowerThanOrEquals;
    protected String jobDefinitionId;
    protected List<String> tenantIds;
    protected Boolean withoutTenantId;
    protected Boolean includeJobsWithoutTenantId;
    protected Boolean acquired;
    protected List<ConditionQueryParameterDto> dueDates;
    protected List<ConditionQueryParameterDto> createTimes;

    public JobQueryDto() {
    }

    public JobQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @OperatonQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @OperatonQueryParam(value="failedActivityId")
    public void setFailedActivityId(String activityId) {
        this.failedActivityId = activityId;
    }

    @OperatonQueryParam(value="jobId")
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @OperatonQueryParam(value="jobIds", converter=StringSetConverter.class)
    public void setJobIds(Set<String> jobIds) {
        this.jobIds = jobIds;
    }

    @OperatonQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @OperatonQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @OperatonQueryParam(value="processInstanceIds", converter=StringSetConverter.class)
    public void setProcessInstanceIds(Set<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @OperatonQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @OperatonQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @OperatonQueryParam(value="withRetriesLeft", converter=BooleanConverter.class)
    public void setWithRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
    }

    @OperatonQueryParam(value="executable", converter=BooleanConverter.class)
    public void setExecutable(Boolean executable) {
        this.executable = executable;
    }

    @OperatonQueryParam(value="timers", converter=BooleanConverter.class)
    public void setTimers(Boolean timers) {
        this.timers = timers;
    }

    @OperatonQueryParam(value="withException", converter=BooleanConverter.class)
    public void setWithException(Boolean withException) {
        this.withException = withException;
    }

    @OperatonQueryParam(value="messages", converter=BooleanConverter.class)
    public void setMessages(Boolean messages) {
        this.messages = messages;
    }

    @OperatonQueryParam(value="exceptionMessage")
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    @OperatonQueryParam(value="dueDates", converter=ConditionListConverter.class)
    public void setDueDates(List<ConditionQueryParameterDto> dueDates) {
        this.dueDates = dueDates;
    }

    @OperatonQueryParam(value="createTimes", converter=ConditionListConverter.class)
    public void setCreateTimes(List<ConditionQueryParameterDto> createTimes) {
        this.createTimes = createTimes;
    }

    @OperatonQueryParam(value="noRetriesLeft", converter=BooleanConverter.class)
    public void setNoRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
    }

    @OperatonQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @OperatonQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @OperatonQueryParam(value="priorityHigherThanOrEquals", converter=LongConverter.class)
    public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
    }

    @OperatonQueryParam(value="priorityLowerThanOrEquals", converter=LongConverter.class)
    public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
    }

    @OperatonQueryParam(value="jobDefinitionId")
    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    @OperatonQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @OperatonQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @OperatonQueryParam(value="includeJobsWithoutTenantId", converter=BooleanConverter.class)
    public void setIncludeJobsWithoutTenantId(Boolean includeJobsWithoutTenantId) {
        this.includeJobsWithoutTenantId = includeJobsWithoutTenantId;
    }

    @OperatonQueryParam(value="acquired", converter=BooleanConverter.class)
    public void setAcquired(Boolean acquired) {
        this.acquired = acquired;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected JobQuery createNewQuery(ProcessEngine engine) {
        return engine.getManagementService().createJobQuery();
    }

    @Override
    protected void applyFilters(final JobQuery query) {
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.jobId != null) {
            query.jobId(this.jobId);
        }
        if (!CollectionUtil.isEmpty(this.jobIds)) {
            query.jobIds(this.jobIds);
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (!CollectionUtil.isEmpty(this.processInstanceIds)) {
            query.processInstanceIds(this.processInstanceIds);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (Boolean.TRUE.equals(this.withRetriesLeft)) {
            query.withRetriesLeft();
        }
        if (Boolean.TRUE.equals(this.executable)) {
            query.executable();
        }
        if (Boolean.TRUE.equals(this.timers)) {
            if (this.messages != null && this.messages.booleanValue()) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter timers cannot be used together with parameter messages.");
            }
            query.timers();
        }
        if (Boolean.TRUE.equals(this.messages)) {
            if (this.timers != null && this.timers.booleanValue()) {
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Parameter messages cannot be used together with parameter timers.");
            }
            query.messages();
        }
        if (Boolean.TRUE.equals(this.withException)) {
            query.withException();
        }
        if (this.exceptionMessage != null) {
            query.exceptionMessage(this.exceptionMessage);
        }
        if (this.failedActivityId != null) {
            query.failedActivityId(this.failedActivityId);
        }
        if (Boolean.TRUE.equals(this.noRetriesLeft)) {
            query.noRetriesLeft();
        }
        if (Boolean.TRUE.equals(this.active)) {
            query.active();
        }
        if (Boolean.TRUE.equals(this.suspended)) {
            query.suspended();
        }
        if (this.priorityHigherThanOrEquals != null) {
            query.priorityHigherThanOrEquals(this.priorityHigherThanOrEquals.longValue());
        }
        if (this.priorityLowerThanOrEquals != null) {
            query.priorityLowerThanOrEquals(this.priorityLowerThanOrEquals.longValue());
        }
        if (this.jobDefinitionId != null) {
            query.jobDefinitionId(this.jobDefinitionId);
        }
        if (this.dueDates != null) {
            new ApplyDates(){

                @Override
                void setGreaterThan(Date date) {
                    query.duedateHigherThan(date);
                }

                @Override
                void setLowerThan(Date date) {
                    query.duedateLowerThan(date);
                }

                @Override
                String fieldName() {
                    return "due date";
                }
            }.run(this.dueDates);
        }
        if (this.createTimes != null) {
            new ApplyDates(){

                @Override
                void setGreaterThan(Date date) {
                    query.createdAfter(date);
                }

                @Override
                void setLowerThan(Date date) {
                    query.createdBefore(date);
                }

                @Override
                String fieldName() {
                    return "create time";
                }
            }.run(this.createTimes);
        }
        if (!CollectionUtil.isEmpty(this.tenantIds)) {
            query.tenantIdIn(this.tenantIds.toArray(new String[0]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (Boolean.TRUE.equals(this.includeJobsWithoutTenantId)) {
            query.includeJobsWithoutTenantId();
        }
        if (Boolean.TRUE.equals(this.acquired)) {
            query.acquired();
        }
    }

    @Override
    protected void applySortBy(JobQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_JOB_ID_VALUE.equals(sortBy)) {
            query.orderByJobId();
        } else if (SORT_BY_EXECUTION_ID_VALUE.equals(sortBy)) {
            query.orderByExecutionId();
        } else if (SORT_BY_PROCESS_INSTANCE_ID_VALUE.equals(sortBy)) {
            query.orderByProcessInstanceId();
        } else if (SORT_BY_PROCESS_DEFINITION_ID_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionId();
        } else if (SORT_BY_PROCESS_DEFINITION_KEY_VALUE.equals(sortBy)) {
            query.orderByProcessDefinitionKey();
        } else if (SORT_BY_JOB_RETRIES_VALUE.equals(sortBy)) {
            query.orderByJobRetries();
        } else if (SORT_BY_JOB_DUEDATE_VALUE.equals(sortBy)) {
            query.orderByJobDuedate();
        } else if (SORT_BY_JOB_PRIORITY_VALUE.equals(sortBy)) {
            query.orderByJobPriority();
        } else if (SORT_BY_TENANT_ID.equals(sortBy)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_EXECUTION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_RETRIES_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_DUEDATE_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_JOB_PRIORITY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }

    private abstract class ApplyDates {
        private ApplyDates() {
        }

        void run(List<ConditionQueryParameterDto> dates) {
            DateConverter dateConverter = new DateConverter();
            dateConverter.setObjectMapper(JobQueryDto.this.objectMapper);
            for (ConditionQueryParameterDto conditionQueryParam : dates) {
                Date date;
                String op = conditionQueryParam.getOperator();
                try {
                    date = dateConverter.convertQueryParameterToType((String)conditionQueryParam.getValue());
                }
                catch (RestException e) {
                    throw new InvalidRequestException(e.getStatus(), e, "Invalid " + this.fieldName() + " format: " + e.getMessage());
                }
                if ("gt".equals(op)) {
                    this.setGreaterThan(date);
                    continue;
                }
                if ("lt".equals(op)) {
                    this.setLowerThan(date);
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid " + this.fieldName() + " comparator specified: " + op);
            }
        }

        abstract String fieldName();

        abstract void setGreaterThan(Date var1);

        abstract void setLowerThan(Date var1);
    }
}

