/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.hal.cache;

import io.openbpm.bpm.engine.impl.util.ClockUtil;
import io.openbpm.bpm.engine.rest.cache.Cache;
import io.openbpm.bpm.engine.rest.hal.cache.HalResourceCacheEntry;
import io.openbpm.bpm.engine.rest.hal.cache.HalResourceCacheEntryComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class DefaultHalResourceCache
implements Cache {
    public static final Comparator<HalResourceCacheEntry> COMPARATOR = HalResourceCacheEntryComparator.getInstance();
    protected int capacity;
    protected long secondsToLive;
    protected Map<String, HalResourceCacheEntry> cache;

    public DefaultHalResourceCache() {
        this(100, 100L);
    }

    public DefaultHalResourceCache(int capacity, long secondsToLive) {
        this.capacity = capacity;
        this.secondsToLive = secondsToLive;
        this.cache = new HashMap<String, HalResourceCacheEntry>();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public long getSecondsToLive() {
        return this.secondsToLive;
    }

    public void setSecondsToLive(long secondsToLive) {
        this.secondsToLive = secondsToLive;
    }

    public int size() {
        return this.cache.size();
    }

    @Override
    public void put(String id, Object resource) {
        this.cache.put(id, new HalResourceCacheEntry(id, resource));
        this.ensureCapacityLimit();
    }

    public void remove(String id) {
        this.cache.remove(id);
    }

    @Override
    public Object get(String id) {
        HalResourceCacheEntry cacheEntry = this.cache.get(id);
        if (cacheEntry != null) {
            if (this.expired(cacheEntry)) {
                this.remove(cacheEntry.getId());
                return null;
            }
            return cacheEntry.getResource();
        }
        return null;
    }

    @Override
    public void destroy() {
        this.cache.clear();
    }

    protected void ensureCapacityLimit() {
        if (this.size() > this.getCapacity()) {
            HalResourceCacheEntry resourceToRemove;
            ArrayList<HalResourceCacheEntry> resources = new ArrayList<HalResourceCacheEntry>(this.cache.values());
            TreeSet<HalResourceCacheEntry> remainingResources = new TreeSet<HalResourceCacheEntry>(COMPARATOR);
            for (HalResourceCacheEntry resource : resources) {
                if (this.expired(resource)) {
                    this.remove(resource.getId());
                } else {
                    remainingResources.add(resource);
                }
                if (this.size() > this.getCapacity()) continue;
                return;
            }
            while (remainingResources.size() > this.capacity && (resourceToRemove = (HalResourceCacheEntry)remainingResources.pollFirst()) != null) {
                this.remove(resourceToRemove.getId());
            }
        }
    }

    protected boolean expired(HalResourceCacheEntry entry) {
        return entry.getCreateTime() + this.secondsToLive * 1000L < ClockUtil.getCurrentTime().getTime();
    }
}

