/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl;

import io.openbpm.bpm.engine.rest.exception.RestException;
import io.openbpm.bpm.engine.rest.spi.FetchAndLockHandler;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.ServiceLoader;

public class FetchAndLockContextListener
implements ServletContextListener {
    protected static FetchAndLockHandler fetchAndLockHandler;

    public void contextInitialized(ServletContextEvent sce) {
        if (fetchAndLockHandler == null) {
            fetchAndLockHandler = this.lookupFetchAndLockHandler();
            fetchAndLockHandler.contextInitialized(sce);
            fetchAndLockHandler.start();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        fetchAndLockHandler.shutdown();
    }

    public static FetchAndLockHandler getFetchAndLockHandler() {
        return fetchAndLockHandler;
    }

    protected FetchAndLockHandler lookupFetchAndLockHandler() {
        ServiceLoader<FetchAndLockHandler> serviceLoader = ServiceLoader.load(FetchAndLockHandler.class);
        Iterator<FetchAndLockHandler> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not find an implementation of the " + FetchAndLockHandler.class.getSimpleName() + "- SPI");
    }
}

