/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricActivityInstance;
import io.openbpm.bpm.engine.history.HistoricActivityInstanceQuery;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricActivityInstanceDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricActivityInstanceQueryDto;
import io.openbpm.bpm.engine.rest.history.HistoricActivityInstanceRestService;
import io.openbpm.bpm.engine.rest.sub.history.HistoricActivityInstanceResource;
import io.openbpm.bpm.engine.rest.sub.history.impl.HistoricActivityInstanceResourceImpl;
import io.openbpm.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class HistoricActivityInstanceRestServiceImpl
implements HistoricActivityInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricActivityInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricActivityInstanceResource getHistoricCaseInstance(String activityInstanceId) {
        return new HistoricActivityInstanceResourceImpl(this.processEngine, activityInstanceId);
    }

    @Override
    public List<HistoricActivityInstanceDto> getHistoricActivityInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricActivityInstanceQueryDto queryHistoricActivityInstanceDto = new HistoricActivityInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricActivityInstances(queryHistoricActivityInstanceDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricActivityInstanceDto> queryHistoricActivityInstances(HistoricActivityInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricActivityInstance> matchingHistoricActivityInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricActivityInstanceDto> historicActivityInstanceResults = new ArrayList<HistoricActivityInstanceDto>();
        for (HistoricActivityInstance historicActivityInstance : matchingHistoricActivityInstances) {
            HistoricActivityInstanceDto resultHistoricActivityInstance = new HistoricActivityInstanceDto();
            HistoricActivityInstanceDto.fromHistoricActivityInstance(resultHistoricActivityInstance, historicActivityInstance);
            historicActivityInstanceResults.add(resultHistoricActivityInstance);
        }
        return historicActivityInstanceResults;
    }

    @Override
    public CountResultDto getHistoricActivityInstancesCount(UriInfo uriInfo) {
        HistoricActivityInstanceQueryDto queryDto = new HistoricActivityInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricActivityInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricActivityInstancesCount(HistoricActivityInstanceQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricActivityInstanceQuery query = (HistoricActivityInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

