/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.history.HistoricCaseInstance;
import io.openbpm.bpm.engine.history.HistoricCaseInstanceQuery;
import io.openbpm.bpm.engine.rest.dto.CountResultDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricCaseInstanceDto;
import io.openbpm.bpm.engine.rest.dto.history.HistoricCaseInstanceQueryDto;
import io.openbpm.bpm.engine.rest.history.HistoricCaseInstanceRestService;
import io.openbpm.bpm.engine.rest.sub.history.HistoricCaseInstanceResource;
import io.openbpm.bpm.engine.rest.sub.history.impl.HistoricCaseInstanceResourceImpl;
import io.openbpm.bpm.engine.rest.util.QueryUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.List;

public class HistoricCaseInstanceRestServiceImpl
implements HistoricCaseInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricCaseInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricCaseInstanceResource getHistoricCaseInstance(String caseInstanceId) {
        return new HistoricCaseInstanceResourceImpl(this.processEngine, caseInstanceId);
    }

    @Override
    public List<HistoricCaseInstanceDto> getHistoricCaseInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricCaseInstanceQueryDto queryHistoricCaseInstanceDto = new HistoricCaseInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricCaseInstances(queryHistoricCaseInstanceDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricCaseInstanceDto> queryHistoricCaseInstances(HistoricCaseInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        HistoricCaseInstanceQuery query = (HistoricCaseInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricCaseInstance> matchingHistoricCaseInstances = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricCaseInstanceDto> historicCaseInstanceDtoResults = new ArrayList<HistoricCaseInstanceDto>();
        for (HistoricCaseInstance historicCaseInstance : matchingHistoricCaseInstances) {
            HistoricCaseInstanceDto resultHistoricCaseInstanceDto = HistoricCaseInstanceDto.fromHistoricCaseInstance(historicCaseInstance);
            historicCaseInstanceDtoResults.add(resultHistoricCaseInstanceDto);
        }
        return historicCaseInstanceDtoResults;
    }

    @Override
    public CountResultDto getHistoricCaseInstancesCount(UriInfo uriInfo) {
        HistoricCaseInstanceQueryDto queryDto = new HistoricCaseInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricCaseInstancesCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricCaseInstancesCount(HistoricCaseInstanceQueryDto queryDto) {
        HistoricCaseInstanceQuery query = (HistoricCaseInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        return new CountResultDto(count);
    }
}

