/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub;

import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.query.Query;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.sub.impl.VariableResponseProvider;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

public abstract class AbstractResourceProvider<T extends Query<?, U>, U, DTO> {
    protected String id;
    protected ProcessEngine engine;

    protected AbstractResourceProvider(String detailId, ProcessEngine engine) {
        this.id = detailId;
        this.engine = engine;
    }

    @GET
    @Produces(value={"application/json"})
    public DTO getResource(@QueryParam(value="deserializeValue") @DefaultValue(value="true") boolean deserializeObjectValue) {
        Object variableInstance = this.baseQueryForVariable(deserializeObjectValue).singleResult();
        if (variableInstance != null) {
            return this.transformToDto(variableInstance);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, this.getResourceNameForErrorMessage() + " with Id '" + this.id + "' does not exist.");
    }

    @GET
    @Path(value="/data")
    public Response getResourceBinary() {
        Object queryResult = this.baseQueryForBinaryVariable().singleResult();
        if (queryResult != null) {
            TypedValue variableInstance = this.transformQueryResultIntoTypedValue(queryResult);
            return new VariableResponseProvider().getResponseForTypedVariable(variableInstance, this.id);
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, this.getResourceNameForErrorMessage() + " with Id '" + this.id + "' does not exist.");
    }

    protected String getId() {
        return this.id;
    }

    protected ProcessEngine getEngine() {
        return this.engine;
    }

    protected abstract Query<T, U> baseQueryForBinaryVariable();

    protected abstract Query<T, U> baseQueryForVariable(boolean var1);

    protected abstract TypedValue transformQueryResultIntoTypedValue(U var1);

    protected abstract DTO transformToDto(U var1);

    protected abstract String getResourceNameForErrorMessage();
}

