/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.rest.sub.history.impl;

import io.openbpm.bpm.engine.AuthorizationException;
import io.openbpm.bpm.engine.HistoryService;
import io.openbpm.bpm.engine.ProcessEngine;
import io.openbpm.bpm.engine.ProcessEngineException;
import io.openbpm.bpm.engine.history.HistoricJobLog;
import io.openbpm.bpm.engine.rest.dto.history.HistoricJobLogDto;
import io.openbpm.bpm.engine.rest.exception.InvalidRequestException;
import io.openbpm.bpm.engine.rest.sub.history.HistoricJobLogResource;
import jakarta.ws.rs.core.Response;

public class HistoricJobLogResourceImpl
implements HistoricJobLogResource {
    protected String id;
    protected ProcessEngine engine;

    public HistoricJobLogResourceImpl(String id, ProcessEngine engine) {
        this.id = id;
        this.engine = engine;
    }

    @Override
    public HistoricJobLogDto getHistoricJobLog() {
        HistoryService historyService = this.engine.getHistoryService();
        HistoricJobLog historicJobLog = (HistoricJobLog)historyService.createHistoricJobLogQuery().logId(this.id).singleResult();
        if (historicJobLog == null) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, "Historic job log with id " + this.id + " does not exist");
        }
        return HistoricJobLogDto.fromHistoricJobLog(historicJobLog);
    }

    @Override
    public String getStacktrace() {
        try {
            HistoryService historyService = this.engine.getHistoryService();
            return historyService.getHistoricJobLogExceptionStacktrace(this.id);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ProcessEngineException e) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, e.getMessage());
        }
    }
}

